/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.openeuler.sun.security.internal.spec.TlsMasterSecretParameterSpec;
import org.openeuler.sun.security.ssl.CipherSuite;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.ProtocolVersion;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLKeyDerivationGenerator;
import org.openeuler.sun.security.ssl.SSLLogger;

enum SSLMasterKeyDerivation implements SSLKeyDerivationGenerator
{
    SSL30("kdf_ssl30"),
    TLS10("kdf_tls10"),
    GMTLS("kdf_gmtls"),
    TLS12("kdf_tls12");

    final String name;

    private SSLMasterKeyDerivation(String name) {
        this.name = name;
    }

    static SSLMasterKeyDerivation valueOf(ProtocolVersion protocolVersion) {
        switch (protocolVersion) {
            case SSL30: {
                return SSL30;
            }
            case TLS10: 
            case TLS11: {
                return TLS10;
            }
            case GMTLS: {
                return GMTLS;
            }
            case TLS12: {
                return TLS12;
            }
        }
        return null;
    }

    @Override
    public SSLKeyDerivation createKeyDerivation(HandshakeContext context, SecretKey secretKey) throws IOException {
        return new LegacyMasterKeyDerivation(context, secretKey);
    }

    private static final class LegacyMasterKeyDerivation
    implements SSLKeyDerivation {
        final HandshakeContext context;
        final SecretKey preMasterSecret;

        LegacyMasterKeyDerivation(HandshakeContext context, SecretKey preMasterSecret) {
            this.context = context;
            this.preMasterSecret = preMasterSecret;
        }

        @Override
        public SecretKey deriveKey(String algorithm, AlgorithmParameterSpec params) throws IOException {
            TlsMasterSecretParameterSpec spec;
            CipherSuite.HashAlg hashAlg;
            String masterAlg;
            CipherSuite cipherSuite = this.context.negotiatedCipherSuite;
            ProtocolVersion protocolVersion = this.context.negotiatedProtocol;
            byte majorVersion = protocolVersion.major;
            byte minorVersion = protocolVersion.minor;
            if (protocolVersion.useGMTLSSpec() || this.context.t12WithGMCipherSuite) {
                masterAlg = "GMTlsMasterSecret";
                hashAlg = CipherSuite.HashAlg.H_SM3;
            } else if (protocolVersion.id >= ProtocolVersion.TLS12.id) {
                masterAlg = "SunTls12MasterSecret";
                hashAlg = cipherSuite.hashAlg;
            } else {
                masterAlg = "SunTlsMasterSecret";
                hashAlg = CipherSuite.HashAlg.H_NONE;
            }
            if (this.context.handshakeSession.useExtendedMasterSecret && !protocolVersion.useGMTLSSpec()) {
                masterAlg = "SunTlsExtendedMasterSecret";
                this.context.handshakeHash.utilize();
                byte[] sessionHash = this.context.handshakeHash.digest();
                spec = new TlsMasterSecretParameterSpec(this.preMasterSecret, majorVersion & 0xFF, minorVersion & 0xFF, sessionHash, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
            } else {
                spec = new TlsMasterSecretParameterSpec(this.preMasterSecret, majorVersion & 0xFF, minorVersion & 0xFF, this.context.clientHelloRandom.randomBytes, this.context.serverHelloRandom.randomBytes, hashAlg.name, hashAlg.hashLength, hashAlg.blockSize);
            }
            try {
                KeyGenerator kg = JsseJce.getKeyGenerator(masterAlg);
                kg.init((AlgorithmParameterSpec)spec);
                return kg.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iae) {
                if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                    SSLLogger.fine("RSA master secret generation error.", iae);
                }
                throw new ProviderException(iae);
            }
        }
    }
}

