/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.sun.security.ssl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLHandshakeException;
import org.openeuler.sun.misc.HexDumpEncoder;
import org.openeuler.sun.security.ssl.Alert;
import org.openeuler.sun.security.ssl.ClientHandshakeContext;
import org.openeuler.sun.security.ssl.ConnectionContext;
import org.openeuler.sun.security.ssl.HandshakeContext;
import org.openeuler.sun.security.ssl.HandshakeOutStream;
import org.openeuler.sun.security.ssl.HandshakeProducer;
import org.openeuler.sun.security.ssl.JsseJce;
import org.openeuler.sun.security.ssl.Record;
import org.openeuler.sun.security.ssl.SM2KeyExchange;
import org.openeuler.sun.security.ssl.SSLConsumer;
import org.openeuler.sun.security.ssl.SSLCredentials;
import org.openeuler.sun.security.ssl.SSLHandshake;
import org.openeuler.sun.security.ssl.SSLKeyDerivation;
import org.openeuler.sun.security.ssl.SSLKeyExchange;
import org.openeuler.sun.security.ssl.SSLLogger;
import org.openeuler.sun.security.ssl.SSLPossession;
import org.openeuler.sun.security.ssl.SSLTrafficKeyDerivation;
import org.openeuler.sun.security.ssl.ServerHandshakeContext;
import org.openeuler.sun.security.ssl.SupportedGroupsExtension;
import org.openeuler.sun.security.ssl.Utilities;

final class SM2ClientKeyExchange {
    static final SSLConsumer sm2HandshakeConsumer = new SM2ClientKeyExchangeConsumer();
    static final HandshakeProducer sm2HandshakeProducer = new SM2ClientKeyExchangeProducer();

    SM2ClientKeyExchange() {
    }

    private static final class SM2ClientKeyExchangeConsumer
    implements SSLConsumer {
        private SM2ClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext context, ByteBuffer message) throws IOException {
            ServerHandshakeContext shc = (ServerHandshakeContext)context;
            SM2KeyExchange.SM2Possession sm2Possession = null;
            for (SSLPossession possession : shc.handshakePossessions) {
                if (!(possession instanceof SM2KeyExchange.SM2Possession)) continue;
                sm2Possession = (SM2KeyExchange.SM2Possession)possession;
                break;
            }
            if (sm2Possession == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "No expected SM2 possessions for client key exchange");
            }
            ECParameterSpec params = sm2Possession.publicKey.getParams();
            SupportedGroupsExtension.NamedGroup namedGroup = SupportedGroupsExtension.NamedGroup.valueOf(params);
            if (namedGroup == null) {
                throw shc.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Unsupported EC server cert for SM2 client key exchange");
            }
            SSLKeyExchange ke = SSLKeyExchange.valueOf(shc.negotiatedCipherSuite.keyExchange, shc.negotiatedProtocol);
            if (ke == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SM2ClientKeyExchangeMessage cke = new SM2ClientKeyExchangeMessage((HandshakeContext)shc, message);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming SM2 ClientKeyExchange handshake message", cke);
            }
            try {
                ECPoint point = JsseJce.decodePoint(cke.encodedPoint, params.getCurve());
                ECPublicKeySpec spec = new ECPublicKeySpec(point, params);
                KeyFactory kf = JsseJce.getKeyFactory("EC");
                ECPublicKey peerPublicKey = (ECPublicKey)kf.generatePublic(spec);
                if (shc.algorithmConstraints != null && !shc.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), peerPublicKey)) {
                    throw new SSLHandshakeException("ECPublicKey does not comply to algorithm constraints");
                }
                shc.handshakeCredentials.add(new SM2KeyExchange.SM2Credentials(peerPublicKey, namedGroup));
            }
            catch (IOException | GeneralSecurityException e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Could not generate ECPublicKey").initCause(e);
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(shc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            shc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(shc.negotiatedProtocol);
            if (kd == null) {
                throw shc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)shc.negotiatedProtocol));
            }
            shc.handshakeKeyDerivation = kd.createKeyDerivation(shc, masterSecret);
        }
    }

    private static final class SM2ClientKeyExchangeProducer
    implements HandshakeProducer {
        private SM2ClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext context, SSLHandshake.HandshakeMessage message) throws IOException {
            ClientHandshakeContext chc = (ClientHandshakeContext)context;
            SM2KeyExchange.SM2Credentials sm2Credentials = null;
            for (SSLCredentials cd : chc.handshakeCredentials) {
                if (!(cd instanceof SM2KeyExchange.SM2Credentials)) continue;
                sm2Credentials = (SM2KeyExchange.SM2Credentials)cd;
                break;
            }
            if (sm2Credentials == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "No SM2 credentials negotiated for client key exchange");
            }
            SM2KeyExchange.SM2Possession sm2Possession = new SM2KeyExchange.SM2Possession(sm2Credentials, chc.sslContext.getSecureRandom());
            chc.handshakePossessions.add(sm2Possession);
            SM2ClientKeyExchangeMessage cke = new SM2ClientKeyExchangeMessage((HandshakeContext)chc, sm2Possession.publicKey);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced SM2 ClientKeyExchange handshake message", cke);
            }
            cke.write(chc.handshakeOutput);
            chc.handshakeOutput.flush();
            SSLKeyExchange ke = SSLKeyExchange.valueOf(chc.negotiatedCipherSuite.keyExchange, chc.negotiatedProtocol);
            if (ke == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation masterKD = ke.createKeyDerivation(chc);
            SecretKey masterSecret = masterKD.deriveKey("MasterSecret", null);
            chc.handshakeSession.setMasterSecret(masterSecret);
            SSLTrafficKeyDerivation kd = SSLTrafficKeyDerivation.valueOf(chc.negotiatedProtocol);
            if (kd == null) {
                throw chc.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)chc.negotiatedProtocol));
            }
            chc.handshakeKeyDerivation = kd.createKeyDerivation(chc, masterSecret);
            return null;
        }
    }

    private static final class SM2ClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final byte CURVE_NAMED_CURVE = 3;
        private final byte[] encodedPoint;

        SM2ClientKeyExchangeMessage(HandshakeContext handshakeContext, ECPublicKey publicKey) {
            super(handshakeContext);
            ECPoint point = publicKey.getW();
            ECParameterSpec params = publicKey.getParams();
            this.encodedPoint = JsseJce.encodePoint(point, params.getCurve());
        }

        SM2ClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer m) throws IOException {
            super(handshakeContext);
            Record.getInt8(m);
            Record.getInt16(m);
            this.encodedPoint = m.remaining() != 0 ? Record.getBytes8(m) : new byte[0];
        }

        @Override
        public SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        public int messageLength() {
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                return 0;
            }
            return 1 + this.encodedPoint.length + 3;
        }

        @Override
        public void send(HandshakeOutStream hos) throws IOException {
            hos.putInt8(3);
            hos.putInt16(SupportedGroupsExtension.NamedGroup.SM2P256V1.id);
            if (this.encodedPoint != null && this.encodedPoint.length != 0) {
                hos.putBytes8(this.encodedPoint);
            }
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"SM2 ClientKeyExchange\": '{'\n  \"sm2 public\": '{'\n{0}\n  '}',\n'}'", Locale.ENGLISH);
            if (this.encodedPoint == null || this.encodedPoint.length == 0) {
                Object[] messageFields = new Object[]{"    <implicit>"};
                return messageFormat.format(messageFields);
            }
            HexDumpEncoder hexEncoder = new HexDumpEncoder();
            Object[] messageFields = new Object[]{Utilities.indent(hexEncoder.encodeBuffer(this.encodedPoint), "    ")};
            return messageFormat.format(messageFields);
        }
    }
}

