/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import org.openeuler.gm.GMTlsUtil;
import org.openeuler.sun.security.internal.interfaces.TlsMasterSecret;
import org.openeuler.sun.security.internal.spec.TlsMasterSecretParameterSpec;

public class GMTlsMasterSecretGenerator
extends KeyGeneratorSpi {
    private static final String MSG = "GMTlsMasterSecretGenerator must be initialized using a TlsMasterSecretParameterSpec";
    private TlsMasterSecretParameterSpec spec;
    private int protocolVersion;

    @Override
    protected void engineInit(SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof TlsMasterSecretParameterSpec)) {
            throw new InvalidAlgorithmParameterException(MSG);
        }
        this.spec = (TlsMasterSecretParameterSpec)params;
        if (!"RAW".equals(this.spec.getPremasterSecret().getFormat())) {
            throw new InvalidAlgorithmParameterException("Key format must be RAW");
        }
        this.protocolVersion = this.spec.getMajorVersion() << 8 | this.spec.getMinorVersion();
        if (this.protocolVersion != 257 && this.protocolVersion != 771) {
            throw new InvalidAlgorithmParameterException("Only GM TLS 1.1 supported");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        throw new InvalidParameterException(MSG);
    }

    @Override
    protected SecretKey engineGenerateKey() {
        int premasterMinor;
        int premasterMajor;
        if (this.spec == null) {
            throw new IllegalStateException("GMTlsMasterSecretGenerator must be initialized");
        }
        SecretKey premasterKey = this.spec.getPremasterSecret();
        byte[] premaster = premasterKey.getEncoded();
        if (premasterKey.getAlgorithm().equals("TlsRsaPremasterSecret")) {
            premasterMajor = premaster[0] & 0xFF;
            premasterMinor = premaster[1] & 0xFF;
        } else {
            premasterMajor = -1;
            premasterMinor = -1;
        }
        try {
            byte[] seed;
            byte[] label;
            byte[] extendedMasterSecretSessionHash = this.spec.getExtendedMasterSecretSessionHash();
            if (extendedMasterSecretSessionHash.length != 0) {
                label = GMTlsUtil.LABEL_EXTENDED_MASTER_SECRET;
                seed = extendedMasterSecretSessionHash;
            } else {
                byte[] clientRandom = this.spec.getClientRandom();
                byte[] serverRandom = this.spec.getServerRandom();
                label = GMTlsUtil.LABEL_MASTER_SECRET;
                seed = GMTlsUtil.concat(clientRandom, serverRandom);
            }
            byte[] master = GMTlsUtil.doGMTLS11PRF(premaster, label, seed, 48, this.spec.getPRFHashAlg(), this.spec.getPRFHashLength(), this.spec.getPRFBlockSize());
            return new GMTlsMasterSecretKey(master, premasterMajor, premasterMinor);
        }
        catch (DigestException | NoSuchAlgorithmException e) {
            throw new ProviderException(e);
        }
    }

    private static final class GMTlsMasterSecretKey
    implements TlsMasterSecret {
        private byte[] key;
        private final int majorVersion;
        private final int minorVersion;

        GMTlsMasterSecretKey(byte[] key, int majorVersion, int minorVersion) {
            this.key = key;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public String getAlgorithm() {
            return "TlsMasterSecret";
        }

        public String getFormat() {
            return "RAW";
        }

        public byte[] getEncoded() {
            return (byte[])this.key.clone();
        }
    }
}

