/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.security.DigestException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import org.openeuler.gm.GMConstants;

public class GMTlsUtil {
    private static final byte[] B0 = new byte[0];
    static final byte[] LABEL_MASTER_SECRET = new byte[]{109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    static final byte[] LABEL_EXTENDED_MASTER_SECRET = new byte[]{101, 120, 116, 101, 110, 100, 101, 100, 32, 109, 97, 115, 116, 101, 114, 32, 115, 101, 99, 114, 101, 116};
    static final byte[] LABEL_KEY_EXPANSION = new byte[]{107, 101, 121, 32, 101, 120, 112, 97, 110, 115, 105, 111, 110};
    static final byte[] LABEL_CLIENT_WRITE_KEY = new byte[]{99, 108, 105, 101, 110, 116, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_SERVER_WRITE_KEY = new byte[]{115, 101, 114, 118, 101, 114, 32, 119, 114, 105, 116, 101, 32, 107, 101, 121};
    static final byte[] LABEL_IV_BLOCK = new byte[]{73, 86, 32, 98, 108, 111, 99, 107};
    private static final byte[] HMAC_ipad64 = GMTlsUtil.genPad((byte)54, 64);
    private static final byte[] HMAC_ipad128 = GMTlsUtil.genPad((byte)54, 128);
    private static final byte[] HMAC_opad64 = GMTlsUtil.genPad((byte)92, 64);
    private static final byte[] HMAC_opad128 = GMTlsUtil.genPad((byte)92, 128);

    static byte[] genPad(byte b, int count) {
        byte[] padding = new byte[count];
        Arrays.fill(padding, b);
        return padding;
    }

    static byte[] concat(byte[] b1, byte[] b2) {
        int n1 = b1.length;
        int n2 = b2.length;
        byte[] b = new byte[n1 + n2];
        System.arraycopy(b1, 0, b, 0, n1);
        System.arraycopy(b2, 0, b, n1, n2);
        return b;
    }

    static byte[] doGMTLS11PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, String prfHash, int prfHashLength, int prfBlockSize) throws NoSuchAlgorithmException, DigestException {
        if (prfHash == null) {
            throw new NoSuchAlgorithmException("Unspecified PRF algorithm");
        }
        MessageDigest prfMD = MessageDigest.getInstance(prfHash);
        return GMTlsUtil.doGMTLS11PRF(secret, labelBytes, seed, outputLength, prfMD, prfHashLength, prfBlockSize);
    }

    static byte[] doGMTLS11PRF(byte[] secret, byte[] labelBytes, byte[] seed, int outputLength, MessageDigest mdPRF, int mdPRFLen, int mdPRFBlockSize) throws DigestException {
        byte[] opad;
        byte[] ipad;
        if (secret == null) {
            secret = B0;
        }
        if (secret.length > mdPRFBlockSize) {
            secret = mdPRF.digest(secret);
        }
        byte[] output = new byte[outputLength];
        switch (mdPRFBlockSize) {
            case 64: {
                ipad = (byte[])HMAC_ipad64.clone();
                opad = (byte[])HMAC_opad64.clone();
                break;
            }
            case 128: {
                ipad = (byte[])HMAC_ipad128.clone();
                opad = (byte[])HMAC_opad128.clone();
                break;
            }
            default: {
                throw new DigestException("Unexpected block size.");
            }
        }
        GMTlsUtil.expand(mdPRF, mdPRFLen, secret, 0, secret.length, labelBytes, seed, output, ipad, opad);
        return output;
    }

    private static void expand(MessageDigest digest, int hmacSize, byte[] secret, int secOff, int secLen, byte[] label, byte[] seed, byte[] output, byte[] pad1, byte[] pad2) throws DigestException {
        int k;
        for (int i = 0; i < secLen; ++i) {
            int n = i;
            pad1[n] = (byte)(pad1[n] ^ secret[i + secOff]);
            int n2 = i;
            pad2[n2] = (byte)(pad2[n2] ^ secret[i + secOff]);
        }
        byte[] tmp = new byte[hmacSize];
        byte[] aBytes = null;
        int ofs = 0;
        for (int remaining = output.length; remaining > 0; remaining -= k) {
            digest.update(pad1);
            if (aBytes == null) {
                digest.update(label);
                digest.update(seed);
            } else {
                digest.update(aBytes);
            }
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            if (aBytes == null) {
                aBytes = new byte[hmacSize];
            }
            digest.digest(aBytes, 0, hmacSize);
            digest.update(pad1);
            digest.update(aBytes);
            digest.update(label);
            digest.update(seed);
            digest.digest(tmp, 0, hmacSize);
            digest.update(pad2);
            digest.update(tmp);
            digest.digest(tmp, 0, hmacSize);
            k = Math.min(hmacSize, remaining);
            for (int i = 0; i < k; ++i) {
                int n = ofs++;
                output[n] = (byte)(output[n] ^ tmp[i]);
            }
        }
    }

    public static boolean isInvalidECCert(String keyType, String sigAlgName) {
        return keyType.equals("EC") && GMConstants.equalsAlgorithm("SM3withSM2", sigAlgName);
    }

    public static boolean isInvalidSM2Cert(String keyType, String sigAlgName) {
        return keyType.equals("SM2") && !GMConstants.equalsAlgorithm("SM3withSM2", sigAlgName);
    }

    public static boolean isInvalidECOrSM2Cert(String keyType, String sigAlgName) {
        return GMTlsUtil.isInvalidECCert(keyType, sigAlgName) || GMTlsUtil.isInvalidSM2Cert(keyType, sigAlgName);
    }

    public static void copyKeyStore(KeyStore srcKeyStore, char[] srcStorePassword, KeyStore destKeyStore, char[] destStorePassword) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Enumeration<String> e = srcKeyStore.aliases();
        while (e.hasMoreElements()) {
            Certificate[] certs;
            String alias = e.nextElement();
            if (srcKeyStore.isCertificateEntry(alias)) {
                Certificate cert = srcKeyStore.getCertificate(alias);
                if (!(cert instanceof X509Certificate)) continue;
                destKeyStore.setCertificateEntry(alias, cert);
                continue;
            }
            if (!srcKeyStore.isKeyEntry(alias) || (certs = srcKeyStore.getCertificateChain(alias)) == null || certs.length <= 0 || !(certs[0] instanceof X509Certificate)) continue;
            Key key = srcKeyStore.getKey(alias, srcStorePassword);
            destKeyStore.setKeyEntry(alias, key, destStorePassword, certs);
        }
    }

    public static boolean isGMCert(X509Certificate certificate) {
        return certificate.getSigAlgName().equalsIgnoreCase("SM3withSM2") || certificate.getSigAlgName().equals("1.2.156.10197.1.501");
    }

    public static boolean isSignCert(X509Certificate certificate) {
        if (GMTlsUtil.isCA(certificate)) {
            return false;
        }
        boolean[] keyUsage = certificate.getKeyUsage();
        return keyUsage != null && keyUsage[0];
    }

    public static boolean isEncCert(X509Certificate certificate) {
        if (GMTlsUtil.isCA(certificate)) {
            return false;
        }
        boolean[] keyUsage = certificate.getKeyUsage();
        if (keyUsage == null) {
            return false;
        }
        return keyUsage[2] || keyUsage[3] || keyUsage[4];
    }

    private static boolean isCA(X509Certificate certificate) {
        return certificate.getBasicConstraints() != -1;
    }
}

