/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.gm;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GMConstants {
    private static final Map<String, GMAlgorithm> GM_ALG_MAP = new HashMap<String, GMAlgorithm>();
    public static final String SM2 = "SM2";
    public static final String SM3_WITH_SM2 = "SM3withSM2";
    public static final String SM3_WITH_SM2_OID = "1.2.156.10197.1.501";
    public static final String EC = "EC";

    private static void initGMAlgorithmMap() {
        GMAlgorithm[] gmAlgorithms;
        for (GMAlgorithm gmAlgorithm : gmAlgorithms = GMAlgorithm.values()) {
            GM_ALG_MAP.put(gmAlgorithm.name().toUpperCase(Locale.ENGLISH), gmAlgorithm);
        }
    }

    public static boolean equalsAlgorithm(String expectedAlg, String alg) {
        if (expectedAlg == null) {
            return alg == null;
        }
        GMAlgorithm gmAlgorithm = GM_ALG_MAP.get(expectedAlg.toUpperCase(Locale.ENGLISH));
        return gmAlgorithm != null ? gmAlgorithm.equals(alg) : expectedAlg.equals(alg);
    }

    static {
        GMConstants.initGMAlgorithmMap();
    }

    static enum GMAlgorithm {
        SM2(new HashSet<String>(Arrays.asList("SM2".toUpperCase(Locale.ENGLISH), "EC".toUpperCase(Locale.ENGLISH)))),
        SM3withSM2(new HashSet<String>(Arrays.asList("SM3withSM2".toUpperCase(Locale.ENGLISH), "1.2.156.10197.1.501".toUpperCase(Locale.ENGLISH))));

        private final Set<String> algNames;

        private GMAlgorithm(Set<String> algNames) {
            this.algNames = algNames;
        }

        boolean equals(String algorithm) {
            if (algorithm == null) {
                return false;
            }
            return this.algNames.contains(algorithm.toUpperCase(Locale.ENGLISH));
        }
    }
}

