/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler.com.sun.crypto.provider;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.crypto.IllegalBlockSizeException;
import org.openeuler.com.sun.crypto.provider.CounterMode;
import org.openeuler.com.sun.crypto.provider.GaloisCounterMode;
import org.openeuler.com.sun.crypto.provider.SymmetricCipher;

final class GCTR
extends CounterMode {
    GCTR(SymmetricCipher cipher, byte[] initialCounterBlk) {
        super(cipher);
        if (initialCounterBlk.length != 16) {
            throw new RuntimeException("length of initial counter block (" + initialCounterBlk.length + ") not equal to AES_BLOCK_SIZE (" + 16 + ")");
        }
        this.iv = initialCounterBlk;
        this.reset();
    }

    @Override
    String getFeedback() {
        return "GCTR";
    }

    private long blocksUntilRollover() {
        ByteBuffer buf = ByteBuffer.wrap(this.counter, this.counter.length - 4, 4);
        buf.order(ByteOrder.BIG_ENDIAN);
        long ctr32 = 0xFFFFFFFFL & (long)buf.getInt();
        long blocksLeft = 0x100000000L - ctr32;
        return blocksLeft;
    }

    int update(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) {
        if (inLen - inOfs > in.length) {
            throw new RuntimeException("input length out of bound");
        }
        if (inLen < 0 || inLen % 16 != 0) {
            throw new RuntimeException("input length unsupported");
        }
        if (out.length - outOfs < inLen) {
            throw new RuntimeException("output buffer too small");
        }
        int numOfCompleteBlocks = inLen / 16;
        long blocksLeft = this.blocksUntilRollover();
        if ((long)numOfCompleteBlocks >= blocksLeft) {
            byte[] encryptedCntr = new byte[16];
            for (int i = 0; i < numOfCompleteBlocks; ++i) {
                this.embeddedCipher.encryptBlock(this.counter, 0, encryptedCntr, 0);
                for (int n = 0; n < 16; ++n) {
                    int index = i * 16 + n;
                    out[outOfs + index] = (byte)(in[inOfs + index] ^ encryptedCntr[n]);
                }
                GaloisCounterMode.increment32(this.counter);
            }
            return inLen;
        }
        return this.encrypt(in, inOfs, inLen, out, outOfs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int doFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws IllegalBlockSizeException {
        try {
            if (inLen < 0) {
                throw new IllegalBlockSizeException("Negative input size!");
            }
            if (inLen > 0) {
                int lastBlockSize = inLen % 16;
                int completeBlkLen = inLen - lastBlockSize;
                this.update(in, inOfs, completeBlkLen, out, outOfs);
                if (lastBlockSize != 0) {
                    byte[] encryptedCntr = new byte[16];
                    this.embeddedCipher.encryptBlock(this.counter, 0, encryptedCntr, 0);
                    for (int n = 0; n < lastBlockSize; ++n) {
                        out[outOfs + completeBlkLen + n] = (byte)(in[inOfs + completeBlkLen + n] ^ encryptedCntr[n]);
                    }
                }
            }
        }
        finally {
            this.reset();
        }
        return inLen;
    }
}

