/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.IOException;
import java.lang.reflect.Field;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Map;
import org.openeuler.BGMJCEConfig;
import org.openeuler.BGMJCEEntries;
import org.openeuler.BGMLegacyJCEEntries;
import org.openeuler.adaptor.ObjectIdentifierHandler;
import org.openeuler.provider.AbstractEntries;
import org.openeuler.provider.AbstractProvider;
import sun.security.util.Debug;
import sun.security.x509.AlgorithmId;

public class BGMJCEProvider
extends AbstractProvider {
    private static final String NAME = "BGMJCEProvider";
    private static final double VERSION = 1.8;
    private static final String INFO = "BiSheng GuoMi JCE providerimplements SM2, SM3, SM3withSM2, SM4";
    private static final Debug debug = Debug.getInstance("Provider");

    private static void initNameTable() {
        block3: {
            try {
                Field nameTableFiled = AlgorithmId.class.getDeclaredField("nameTable");
                nameTableFiled.setAccessible(true);
                Object object = nameTableFiled.get(null);
                if (!(object instanceof Map)) {
                    return;
                }
                Map nameTable = (Map)object;
                nameTable.put(ObjectIdentifierHandler.newObjectIdentifier((String)"1.2.156.10197.1.104"), "SM4");
                nameTable.put(ObjectIdentifierHandler.newObjectIdentifier((String)"1.2.156.10197.1.301"), "SM2");
                nameTable.put(ObjectIdentifierHandler.newObjectIdentifier((String)"1.2.156.10197.1.401"), "SM3");
                nameTable.put(ObjectIdentifierHandler.newObjectIdentifier((String)"1.2.156.10197.1.501"), "SM3withSM2");
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                if (debug == null) break block3;
                debug.println(e.getMessage());
            }
        }
    }

    public static SecureRandom getRandom() {
        return SecureRandomHolder.RANDOM;
    }

    public BGMJCEProvider() {
        super(NAME, 1.8, INFO);
    }

    protected AbstractEntries createEntries(Provider provider) {
        return BGMJCEProvider.createJCEEntries(provider);
    }

    static AbstractEntries createJCEEntries(Provider provider) {
        return BGMJCEConfig.useLegacy() ? new BGMLegacyJCEEntries(provider) : new BGMJCEEntries(provider);
    }

    static {
        BGMJCEProvider.initNameTable();
    }

    private static class SecureRandomHolder {
        static final SecureRandom RANDOM = new SecureRandom();

        private SecureRandomHolder() {
        }
    }
}

