/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class ConstructKeys {
    public static final PublicKey constructPublicKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            key = keyFactory.generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                key = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException ikse2) {
                InvalidKeyException ike = new InvalidKeyException("Cannot construct public key");
                ike.initCause(ikse2);
                throw ike;
            }
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct public key");
            ike.initCause(ikse);
            throw ike;
        }
        return key;
    }

    public static final PrivateKey constructPrivateKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key = null;
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
            return keyFactory.generatePrivate(keySpec);
        }
        catch (NoSuchAlgorithmException nsae) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                key = keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException nsae2) {
                throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
            }
            catch (InvalidKeySpecException ikse2) {
                InvalidKeyException ike = new InvalidKeyException("Cannot construct private key");
                ike.initCause(ikse2);
                throw ike;
            }
        }
        catch (InvalidKeySpecException ikse) {
            InvalidKeyException ike = new InvalidKeyException("Cannot construct private key");
            ike.initCause(ikse);
            throw ike;
        }
        return key;
    }

    private static final SecretKey constructSecretKey(byte[] encodedKey, String encodedKeyAlgorithm) {
        return new SecretKeySpec(encodedKey, encodedKeyAlgorithm);
    }

    public static final Key constructKey(byte[] encoding, String keyAlgorithm, int keyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result = null;
        switch (keyType) {
            case 3: {
                result = ConstructKeys.constructSecretKey(encoding, keyAlgorithm);
                break;
            }
            case 2: {
                result = ConstructKeys.constructPrivateKey(encoding, keyAlgorithm);
                break;
            }
            case 1: {
                result = ConstructKeys.constructPublicKey(encoding, keyAlgorithm);
            }
        }
        return result;
    }
}

