/*
 * Decompiled with CFR 0.152.
 */
package org.openeuler;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import sun.security.util.ObjectIdentifier;

public class ObjectIdentifierHandler {
    private static Constructor<?> objectIdentifierConstructor;

    private static void initObjectIdentifier() {
        try {
            Class<?> clazz = Class.forName("sun.security.util.ObjectIdentifier");
            objectIdentifierConstructor = clazz.getDeclaredConstructor(String.class);
            objectIdentifierConstructor.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }

    private static String getStringOid(int[] values) {
        String ch = ".";
        StringBuilder stringOid = new StringBuilder();
        for (int value : values) {
            stringOid.append(value);
            stringOid.append(ch);
        }
        return stringOid.substring(0, stringOid.length() - 1);
    }

    public static ObjectIdentifier newObjectIdentifier(String oid) throws IOException {
        if (objectIdentifierConstructor == null) {
            throw new IOException("The sun.security.util.ObjectIdentifier class does not exist or the specified constructor does not exist");
        }
        try {
            return (ObjectIdentifier)objectIdentifierConstructor.newInstance(oid);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public static ObjectIdentifier newObjectIdentifier(int[] values) throws IOException {
        String stringOid = ObjectIdentifierHandler.getStringOid(values);
        return ObjectIdentifierHandler.newObjectIdentifier(stringOid);
    }

    static {
        ObjectIdentifierHandler.initObjectIdentifier();
    }
}

