/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.util;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@Beta
public final class OptionalBoolean {
    private static final @NonNull Optional<Boolean> FALSE_OPTIONAL = Optional.of(Boolean.FALSE);
    private static final @NonNull Optional<Boolean> TRUE_OPTIONAL = Optional.of(Boolean.TRUE);
    private static final byte ABSENT = 0;
    private static final byte FALSE = 1;
    private static final byte TRUE = 2;

    private OptionalBoolean() {
        throw new UnsupportedOperationException();
    }

    public static boolean isPresent(byte value) {
        switch (value) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: {
                return true;
            }
        }
        throw OptionalBoolean.invalidValue(value);
    }

    public static boolean get(byte value) {
        switch (value) {
            case 0: {
                throw new IllegalStateException("Field has not been initialized");
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        throw OptionalBoolean.invalidValue(value);
    }

    public static byte of(boolean bool) {
        return bool ? (byte)2 : 1;
    }

    public static byte ofNullable(@Nullable Boolean bool) {
        return bool == null ? (byte)0 : OptionalBoolean.of(bool);
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static @Nullable Boolean toNullable(byte value) {
        switch (value) {
            case 0: {
                return null;
            }
            case 1: {
                return Boolean.FALSE;
            }
            case 2: {
                return Boolean.TRUE;
            }
        }
        throw OptionalBoolean.invalidValue(value);
    }

    public static byte ofOptional(Optional<Boolean> value) {
        return OptionalBoolean.ofNullable(value.orElse(null));
    }

    public static @NonNull Optional<Boolean> toOptional(byte value) {
        switch (value) {
            case 0: {
                return Optional.empty();
            }
            case 1: {
                return FALSE_OPTIONAL;
            }
            case 2: {
                return TRUE_OPTIONAL;
            }
        }
        throw OptionalBoolean.invalidValue(value);
    }

    public static @NonNull String toString(byte value) {
        switch (value) {
            case 0: {
                return "absent";
            }
            case 1: {
                return Boolean.toString(false);
            }
            case 2: {
                return Boolean.toString(true);
            }
        }
        throw OptionalBoolean.invalidValue(value);
    }

    private static IllegalArgumentException invalidValue(byte value) {
        throw new IllegalArgumentException("Invalid field value " + value);
    }
}

