/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class AirflowPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(dependency={"host"}, prefix="dags")
    private final String dag;
    @PathField(dependency={"dag"}, prefix="tasks")
    private final String task;
    @PathField(dependency={"task"}, prefix="runs")
    private final String run;

    @Override
    public String prefix() {
        return "//airflow";
    }

    AirflowPath(String host, String dag, String task, String run) {
        this.host = host;
        this.dag = dag;
        this.task = task;
        this.run = run;
    }

    public static AirflowPathBuilder builder() {
        return new AirflowPathBuilder();
    }

    public AirflowPathBuilder toBuilder() {
        return new AirflowPathBuilder().host(this.host).dag(this.dag).task(this.task).run(this.run);
    }

    public String getHost() {
        return this.host;
    }

    public String getDag() {
        return this.dag;
    }

    public String getTask() {
        return this.task;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AirflowPath)) {
            return false;
        }
        AirflowPath other = (AirflowPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$dag = this.getDag();
        String other$dag = other.getDag();
        if (this$dag == null ? other$dag != null : !this$dag.equals(other$dag)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AirflowPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $dag = this.getDag();
        result = result * 59 + ($dag == null ? 43 : $dag.hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "AirflowPath(host=" + this.getHost() + ", dag=" + this.getDag() + ", task=" + this.getTask() + ", run=" + this.getRun() + ")";
    }

    public static class AirflowPathBuilder {
        private String host;
        private String dag;
        private String task;
        private String run;

        AirflowPathBuilder() {
        }

        public AirflowPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public AirflowPathBuilder dag(String dag) {
            this.dag = dag;
            return this;
        }

        public AirflowPathBuilder task(String task) {
            this.task = task;
            return this;
        }

        public AirflowPathBuilder run(String run) {
            this.run = run;
            return this;
        }

        public AirflowPath build() {
            return new AirflowPath(this.host, this.dag, this.task, this.run);
        }

        public String toString() {
            return "AirflowPath.AirflowPathBuilder(host=" + this.host + ", dag=" + this.dag + ", task=" + this.task + ", run=" + this.run + ")";
        }
    }
}

