/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.cfg.Interval;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import com.atlassian.maven.plugin.clover.internal.AntPropertyHelper;
import com.atlassian.maven.plugin.clover.internal.CloverConfiguration;
import com.atlassian.maven.plugin.clover.internal.ConfigUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.codehaus.doxia.sink.Sink;

@Mojo(name="clover")
public class CloverReportMojo
extends AbstractMojo
implements MavenReport,
CloverConfiguration {
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private ArtifactResolver artifactResolver;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="maven.clover.reportDescriptor")
    private File reportDescriptor;
    @Parameter(property="maven.clover.resolveReportDescriptor", defaultValue="false")
    private boolean resolveReportDescriptor;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}")
    private List<ArtifactRepository> repositories;
    @Parameter(property="maven.clover.cloverDatabase")
    private String cloverDatabase;
    @Parameter(property="maven.clover.singleCloverDatabase", defaultValue="false")
    private boolean singleCloverDatabase;
    @Parameter(property="maven.clover.cloverMergeDatabase", defaultValue="${project.build.directory}/clover/cloverMerge.db", required=true)
    private String cloverMergeDatabase;
    @Parameter(property="maven.clover.outputDirectory", defaultValue="${project.reporting.outputDirectory}/clover", required=true)
    private File outputDirectory;
    @Parameter(property="maven.clover.historyDir", defaultValue="${project.build.directory}/clover/history", required=true)
    private String historyDir;
    @Parameter(property="maven.clover.flushInterval", defaultValue="500")
    private int flushInterval;
    @Parameter(property="maven.clover.waitForFlush", defaultValue="true")
    private boolean waitForFlush;
    @Parameter(property="maven.clover.generateHtml", defaultValue="true")
    private boolean generateHtml;
    @Parameter(property="maven.clover.generatePdf", defaultValue="false")
    private boolean generatePdf;
    @Parameter(property="maven.clover.generateXml", defaultValue="true")
    private boolean generateXml;
    @Parameter(property="maven.clover.generateJson", defaultValue="false")
    private boolean generateJson;
    @Parameter(property="maven.clover.generateHistorical", defaultValue="false")
    private boolean generateHistorical;
    @Parameter(property="maven.clover.orderBy", defaultValue="PcCoveredAsc")
    private String orderBy;
    @Parameter(property="maven.clover.contextFilters", defaultValue="")
    private String contextFilters;
    @Parameter(property="maven.clover.includeFailedTestCoverage", defaultValue="false")
    private boolean includeFailedTestCoverage;
    @Parameter(property="maven.clover.showInnerFunctions", defaultValue="false")
    private boolean showInnerFunctions;
    @Parameter(property="maven.clover.showLambdaFunctions", defaultValue="false")
    private boolean showLambdaFunctions;
    @Parameter(property="maven.clover.showUniqueCoverage", defaultValue="false")
    private boolean showUniqueCoverage;
    @Parameter(property="maven.clover.title", defaultValue="${project.name} ${project.version}")
    private String title;
    @Parameter(property="maven.clover.titleAnchor", defaultValue="${project.url}")
    private String titleAnchor;
    @Parameter(property="maven.clover.charset", defaultValue="UTF-8")
    private String charset;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="maven.clover.licenseLocation")
    private String licenseLocation;
    @Parameter(property="maven.clover.license")
    private String license;
    @Parameter(property="maven.clover.span")
    private String span = Interval.DEFAULT_SPAN.toString();
    @Parameter(property="maven.clover.alwaysReport", defaultValue="true")
    private boolean alwaysReport = true;

    public void execute() throws MojoExecutionException {
        try {
            this.executeReport(Locale.ENGLISH);
        }
        catch (MavenReportException ex) {
            throw new MojoExecutionException("Failed to generate report", (Exception)((Object)ex));
        }
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    public void executeReport(Locale locale) throws MavenReportException {
        File mergedCloverDatabase;
        File singleModuleCloverDatabase;
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"No report being generated for this module.");
        }
        MavenProject lastProject = this.getReactorProjects().get(this.getReactorProjects().size() - 1);
        MavenProject thisProject = this.getProject();
        if (this.isSingleCloverDatabase() && !thisProject.equals((Object)lastProject)) {
            this.getLog().info((CharSequence)"Skipping report generation until the final project in the reactor.");
            return;
        }
        this.outputDirectory.mkdirs();
        if (this.reportDescriptor == null) {
            this.reportDescriptor = this.resolveCloverDescriptor();
        } else if (!this.reportDescriptor.exists()) {
            try {
                this.reportDescriptor = AbstractCloverMojo.getResourceAsFile(this.reportDescriptor.getPath(), this.getLog(), this.getClass().getClassLoader());
            }
            catch (MojoExecutionException e) {
                throw new MavenReportException("Could not resolve report descriptor: " + this.reportDescriptor.getPath(), (Exception)((Object)e));
            }
        }
        this.getLog().info((CharSequence)("Using Clover report descriptor: " + this.reportDescriptor.getAbsolutePath()));
        if (this.title != null && this.title.startsWith("Unnamed")) {
            this.title = this.project.getArtifactId() + " " + this.project.getVersion();
        }
        if ((singleModuleCloverDatabase = new File(this.resolveCloverDatabase())).exists()) {
            this.createAllReportTypes(this.resolveCloverDatabase(), this.title);
        }
        if ((mergedCloverDatabase = new File(this.cloverMergeDatabase)).exists()) {
            this.createAllReportTypes(this.cloverMergeDatabase, this.title + " (Aggregated)");
        }
    }

    private void createAllReportTypes(String database, String titlePrefix) {
        String outpath = this.outputDirectory.getAbsolutePath();
        if (this.generateHtml) {
            this.createReport(database, "html", titlePrefix, outpath, outpath, false);
        }
        if (this.generatePdf) {
            this.createReport(database, "pdf", titlePrefix, outpath + "/clover.pdf", outpath + "/historical.pdf", true);
        }
        if (this.generateXml) {
            this.createReport(database, "xml", titlePrefix, outpath + "/clover.xml", null, false);
        }
        if (this.generateJson) {
            this.createReport(database, "json", titlePrefix, outpath, null, false);
        }
    }

    private void createReport(String database, String format, String title, String output, String historyOut, boolean summary) {
        Project antProject = new Project();
        antProject.init();
        PropertyHelper propertyHelper = PropertyHelper.getPropertyHelper((Project)antProject);
        propertyHelper.setNext((PropertyHelper)new AntPropertyHelper(this.project, this.getLog()));
        antProject.setUserProperty("ant.file", this.reportDescriptor.getAbsolutePath());
        antProject.setCoreLoader(this.getClass().getClassLoader());
        this.addMavenProperties(antProject);
        antProject.setProperty("cloverdb", database);
        antProject.setProperty("output", output);
        antProject.setProperty("history", this.historyDir);
        antProject.setProperty("title", Strings.nullToEmpty((String)title));
        antProject.setProperty("titleAnchor", Strings.nullToEmpty((String)this.titleAnchor));
        String projectDir = this.project.getBasedir().getPath();
        antProject.setProperty("projectDir", projectDir);
        antProject.setProperty("testPattern", "**/src/test/**");
        antProject.setProperty("filter", Strings.nullToEmpty((String)this.contextFilters));
        antProject.setProperty("orderBy", this.orderBy);
        antProject.setProperty("charset", this.charset);
        antProject.setProperty("type", format);
        antProject.setProperty("span", this.span);
        antProject.setProperty("alwaysReport", Boolean.toString(this.alwaysReport));
        antProject.setProperty("summary", Boolean.toString(summary));
        antProject.setProperty("showInnerFunctions", Boolean.toString(this.showInnerFunctions));
        antProject.setProperty("showLambdaFunctions", Boolean.toString(this.showLambdaFunctions));
        antProject.setProperty("showUniqueCoverage", Boolean.toString(this.showUniqueCoverage));
        antProject.setProperty("includeFailedTestCoverage", Boolean.toString(this.includeFailedTestCoverage));
        if (historyOut != null) {
            antProject.setProperty("historyout", historyOut);
        }
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        ProjectHelper.configureProject((Project)antProject, (File)this.reportDescriptor);
        antProject.setBaseDir(this.project.getBasedir());
        String target = this.generateHistorical && this.isHistoricalDirectoryValid(output) && historyOut != null ? "historical" : "current";
        antProject.executeTarget(target);
    }

    private void addMavenProperties(Project antProject) {
        Properties properties = this.getProject().getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            this.getLog().debug((CharSequence)("Setting Property: " + entry.getKey().toString() + " = " + entry.getValue().toString()));
            antProject.setProperty(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    private boolean isHistoricalDirectoryValid(String outFile) {
        boolean isValid = false;
        File dir = new File(this.historyDir);
        if (dir.exists()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                isValid = true;
            } else if (this.generateHistorical) {
                this.getLog().warn((CharSequence)("No Clover historical data found in [" + this.historyDir + "], skipping Clover historical report generation ([" + outFile + "])"));
            }
        } else if (this.generateHistorical) {
            this.getLog().warn((CharSequence)("Clover historical directory [" + this.historyDir + "] does not exist, skipping Clover historical report generation ([" + outFile + "])"));
        }
        return isValid;
    }

    public String getOutputName() {
        return "clover/index";
    }

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.outputDirectory.getAbsoluteFile();
    }

    public String getDescription(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.description");
    }

    private static ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("clover-report", locale, CloverReportMojo.class.getClassLoader());
    }

    @Override
    public MavenProject getProject() {
        return this.project;
    }

    public String getName(Locale locale) {
        return CloverReportMojo.getBundle(locale).getString("report.clover.name");
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        AbstractCloverMojo.waitForFlush(this.waitForFlush, this.flushInterval);
        File singleModuleCloverDatabase = new File(this.resolveCloverDatabase());
        File mergedCloverDatabase = new File(this.cloverMergeDatabase);
        if (singleModuleCloverDatabase.exists() || mergedCloverDatabase.exists()) {
            if (this.generateHtml || this.generatePdf || this.generateXml) {
                canGenerate = true;
            }
        } else {
            this.getLog().warn((CharSequence)"No Clover database found, skipping report generation");
        }
        return canGenerate;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.outputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith("clover") ? new File(reportOutputDirectory, "clover") : reportOutputDirectory;
    }

    protected File resolveCloverDescriptor() throws MavenReportException {
        if (this.resolveReportDescriptor) {
            this.getLog().info((CharSequence)"Attempting to resolve the clover-report configuration as an xml artifact.");
            Artifact artifact = this.repositorySystem.createArtifactWithClassifier(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion(), "xml", "clover-report");
            try {
                ArtifactResult result = this.artifactResolver.resolveArtifact(this.mavenSession.getProjectBuildingRequest(), artifact);
                return result.getArtifact().getFile();
            }
            catch (ArtifactResolverException e) {
                this.getLog().warn((CharSequence)("Failed to resolve artifact " + artifact));
            }
        }
        try {
            this.getLog().info((CharSequence)"Using default-clover-report descriptor.");
            File file = AbstractCloverMojo.getResourceAsFile("default-clover-report.xml", this.getLog(), this.getClass().getClassLoader());
            file.deleteOnExit();
            return file;
        }
        catch (Exception e) {
            throw new MavenReportException("Could not resolve default-clover-report.xml. Please try specifying this via the maven.clover.reportDescriptor property.", e);
        }
    }

    @Override
    public String getCloverDatabase() {
        return this.cloverDatabase;
    }

    @Override
    public String resolveCloverDatabase() {
        return new ConfigUtil(this).resolveCloverDatabase();
    }

    @Override
    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    @Override
    public boolean isSingleCloverDatabase() {
        return this.singleCloverDatabase;
    }
}

