/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.ant.tasks.CloverPassTask;
import com.atlassian.clover.cfg.Percentage;
import com.atlassian.maven.plugin.clover.CloverSetupMojo;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
public class CloverCheckMojo
extends AbstractCloverMojo {
    @Parameter(property="maven.clover.targetPercentage")
    String targetPercentage;
    @Parameter(property="maven.clover.methodPercentage")
    String methodPercentage;
    @Parameter(property="maven.clover.statementPercentage")
    String statementPercentage;
    @Parameter(property="maven.clover.conditionalPercentage")
    String conditionalPercentage;
    @Parameter(property="maven.clover.contextFilters")
    String contextFilters;
    @Parameter(property="maven.clover.codeType")
    String codeType;
    @Parameter(property="maven.clover.failOnViolation", defaultValue="true")
    boolean failOnViolation;
    @Parameter(property="maven.clover.historyDir", defaultValue="${project.build.directory}/clover/history")
    File historyDir;
    @Parameter(property="maven.clover.historyThreshold", defaultValue="0%")
    String historyThreshold;
    @Parameter(property="maven.clover.includeFailedTestCoverage", defaultValue="false")
    private boolean includeFailedTestCoverage;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover check.");
            return;
        }
        if (!this.isInCloverForkedLifecycle()) {
            if (this.areCloverDatabasesAvailable()) {
                super.execute();
                AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
                this.check();
            } else {
                this.getLog().info((CharSequence)"No Clover database found, skipping test coverage verification");
            }
        }
    }

    private void check() throws MojoExecutionException {
        if (new File(this.resolveCloverDatabase()).exists()) {
            this.checkDatabase(this.resolveCloverDatabase());
        }
        if (new File(this.getCloverMergeDatabase()).exists()) {
            this.checkDatabase(this.getCloverMergeDatabase());
        }
    }

    private void checkDatabase(String database) throws MojoExecutionException {
        Project antProject = new Project();
        antProject.init();
        AbstractCloverMojo.registerCloverAntTasks(antProject, this.getLog());
        CloverPassTask cloverPassTask = this.createCloverPassTask(database, antProject);
        cloverPassTask.init();
        cloverPassTask.setInitString(database);
        cloverPassTask.setHaltOnFailure(true);
        cloverPassTask.setFailureProperty("clovercheckproperty");
        cloverPassTask.setIncludeFailedTestCoverage(this.includeFailedTestCoverage);
        if (this.codeType != null) {
            cloverPassTask.setCodeType(this.codeType);
        }
        if (this.targetPercentage != null) {
            cloverPassTask.setTarget(new Percentage(this.targetPercentage));
            this.getLog().info((CharSequence)("Checking for coverage of [" + this.targetPercentage + "] for database [" + database + "]"));
            if (this.methodPercentage != null) {
                cloverPassTask.setMethodTarget(new Percentage(this.methodPercentage));
                this.getLog().info((CharSequence)("Checking for method coverage of [" + this.methodPercentage + "] for database [" + database + "]"));
            }
            if (this.conditionalPercentage != null) {
                cloverPassTask.setConditionalTarget(new Percentage(this.conditionalPercentage));
                this.getLog().info((CharSequence)("Checking for conditional coverage of [" + this.conditionalPercentage + "] for database [" + database + "]"));
            }
            if (this.statementPercentage != null) {
                cloverPassTask.setStatementTarget(new Percentage(this.statementPercentage));
                this.getLog().info((CharSequence)("Checking for statement coverage of [" + this.statementPercentage + "] for database [" + database + "]"));
            }
        } else if (this.historyDir.exists() && this.historyDir.isDirectory()) {
            cloverPassTask.setHistorydir(this.historyDir);
            cloverPassTask.setThreshold(new Percentage(this.historyThreshold));
            this.getLog().info((CharSequence)("Checking coverage against historical data [" + this.historyDir + " +/-" + this.historyThreshold + " ] for database [" + database + "]"));
        } else {
            this.getLog().warn((CharSequence)("Skipping clover:check as 'maven.clover.targetPercentage' is not defined and 'maven.clover.historyDir' (" + this.historyDir.getPath() + ") does not exist or is not a directory."));
            return;
        }
        if (this.contextFilters != null) {
            cloverPassTask.setFilter(this.contextFilters);
        }
        this.setTestSourceRoots(cloverPassTask);
        try {
            cloverPassTask.execute();
        }
        catch (BuildException e) {
            this.getLog().error((CharSequence)antProject.getProperty("clovercheckproperty"));
            if (this.failOnViolation) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            this.getLog().warn((CharSequence)"Clover test percentage coverage is below threshold but failOnViolation is set to  false, preventing the build from failing.");
        }
    }

    private void setTestSourceRoots(CloverPassTask cloverPassTask) {
        String originalSrcTestDir = CloverSetupMojo.getOriginalSrcTestDir(this.getProject().getId());
        if (originalSrcTestDir != null) {
            this.addTestSrcDir(cloverPassTask, originalSrcTestDir);
        }
        List testSourceRoots = this.getProject().getTestCompileSourceRoots();
        this.getLog().warn((CharSequence)("has test file source dir = " + (testSourceRoots.size() > 0)));
        for (String testDir : testSourceRoots) {
            this.getLog().warn((CharSequence)("test file source dir = " + testDir));
            this.addTestSrcDir(cloverPassTask, testDir);
        }
    }

    private void addTestSrcDir(CloverPassTask cloverPassTask, String originalSrcTestDir) {
        FileSet testFiles = new FileSet();
        File dir = new File(originalSrcTestDir);
        if (dir.exists()) {
            testFiles.setDir(dir);
            cloverPassTask.addTestSources(testFiles);
        }
    }

    CloverPassTask createCloverPassTask(String database, Project antProject) {
        return (CloverPassTask)antProject.createTask("clover-check");
    }

    private boolean isInCloverForkedLifecycle() {
        return this.getProject().getBuild().getDirectory().endsWith("clover");
    }
}

