/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractTypeScriptClientCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;

public class TypeScriptAxiosClientCodegen
extends AbstractTypeScriptClientCodegen {
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String WITH_INTERFACES = "withInterfaces";
    public static final String SEPARATE_MODELS_AND_API = "withSeparateModelsAndApi";
    public static final String WITHOUT_PREFIX_ENUMS = "withoutPrefixEnums";
    public static final String USE_SINGLE_REQUEST_PARAMETER = "useSingleRequestParameter";
    public static final String WITH_NODE_IMPORTS = "withNodeImports";
    public static final String STRING_ENUMS = "stringEnums";
    public static final String STRING_ENUMS_DESC = "Generate string enums instead of objects for enum values.";
    public static final String USE_SQUARE_BRACKETS_IN_ARRAY_NAMES = "useSquareBracketsInArrayNames";
    protected String npmRepository = null;
    protected Boolean stringEnums = false;
    private String tsModelPackage = "";

    public TypeScriptAxiosClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}));
        this.importMapping.clear();
        this.reservedWords.add("options");
        this.outputFolder = "generated-code/typescript-axios";
        this.templateDir = "typescript-axios";
        this.embeddedTemplateDir = "typescript-axios";
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url of your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(SEPARATE_MODELS_AND_API, "Put the model and api in separate folders and in separate classes. This requires in addition a value for 'apiPackage' and 'modelPackage'", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption("modelPackage", "package for generated models"));
        this.cliOptions.add(new CliOption("apiPackage", "package for generated api classes"));
        this.cliOptions.add(new CliOption(WITHOUT_PREFIX_ENUMS, "Don't prefix enum names with class names", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(USE_SINGLE_REQUEST_PARAMETER, "Setting this property to true will generate functions with a single argument containing all API endpoint parameters instead of one argument per parameter.", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_NODE_IMPORTS, "Setting this property to true adds imports for NodeJS", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(STRING_ENUMS, STRING_ENUMS_DESC).defaultValue(String.valueOf(this.stringEnums)));
        this.cliOptions.add(new CliOption(USE_SQUARE_BRACKETS_IN_ARRAY_NAMES, "Setting this property to true will add brackets to array attribute names, e.g. my_values[].", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.removeOption("modelPropertyNaming");
    }

    @Override
    public String getName() {
        return "typescript-axios";
    }

    @Override
    public String getHelp() {
        return "Generates a TypeScript client library using axios.";
    }

    private static String getRelativeToRoot(String path) {
        StringBuilder sb = new StringBuilder();
        int slashCount = path.split("/").length;
        if (slashCount == 0) {
            sb.append("./");
        } else {
            for (int i = 0; i < slashCount; ++i) {
                sb.append("../");
            }
        }
        return sb.toString();
    }

    @Override
    public void processOpts() {
        boolean separateModelsAndApi;
        super.processOpts();
        this.tsModelPackage = this.modelPackage.replaceAll("\\.", "/");
        String tsApiPackage = this.apiPackage.replaceAll("\\.", "/");
        String modelRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(this.tsModelPackage);
        String apiRelativeToRoot = TypeScriptAxiosClientCodegen.getRelativeToRoot(tsApiPackage);
        this.additionalProperties.put("tsModelPackage", this.tsModelPackage);
        this.additionalProperties.put("tsApiPackage", tsApiPackage);
        this.additionalProperties.put("apiRelativeToRoot", apiRelativeToRoot);
        this.additionalProperties.put("modelRelativeToRoot", modelRelativeToRoot);
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("baseApi.mustache", "", "base.ts"));
        this.supportingFiles.add(new SupportingFile("common.mustache", "", "common.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", "api.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("npmignore", "", ".npmignore"));
        if (this.additionalProperties.containsKey(SEPARATE_MODELS_AND_API) && (separateModelsAndApi = Boolean.parseBoolean(this.additionalProperties.get(SEPARATE_MODELS_AND_API).toString()))) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.modelPackage, this.apiPackage})) {
                throw new RuntimeException("apiPackage and modelPackage must be defined");
            }
            this.modelTemplateFiles.put("model.mustache", ".ts");
            this.apiTemplateFiles.put("apiInner.mustache", ".ts");
            this.supportingFiles.add(new SupportingFile("modelIndex.mustache", this.tsModelPackage, "index.ts"));
        }
        if (this.additionalProperties.containsKey(STRING_ENUMS)) {
            this.stringEnums = Boolean.parseBoolean(this.additionalProperties.get(STRING_ENUMS).toString());
            this.additionalProperties.put(STRING_ENUMS, this.stringEnums);
        }
        if (this.additionalProperties.containsKey("npmName")) {
            this.addNpmPackageGeneration();
        }
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.updateOperationParameterForEnum(objs);
        OperationMap vals = objs.getOperations();
        List<CodegenOperation> operations = vals.getOperation();
        operations.stream().filter(op -> op.hasConsumes).filter(op -> op.consumes.stream().anyMatch(opc -> opc.values().stream().anyMatch("multipart/form-data"::equals))).forEach(op -> op.vendorExtensions.putIfAbsent("multipartFormData", true));
        return objs;
    }

    private void updateOperationParameterForEnum(OperationsMap operations) {
        for (CodegenOperation op : operations.getOperations().getOperation()) {
            for (CodegenParameter param : op.allParams) {
                if (!Boolean.TRUE.equals(param.isEnum)) continue;
                param.datatypeWithEnum = param.datatypeWithEnum.replace(param.enumName, op.operationIdCamelCase + param.enumName);
            }
        }
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        super.postProcessParameter(parameter);
        if (parameter.isFormParam && parameter.isArray && "binary".equals(parameter.dataFormat)) {
            parameter.isCollectionFormatMulti = true;
        }
    }

    @Override
    public Map<String, ModelsMap> postProcessAllModels(Map<String, ModelsMap> objs) {
        Map<String, ModelsMap> result = super.postProcessAllModels(objs);
        for (ModelsMap entry : result.values()) {
            for (ModelMap model : entry.getModels()) {
                CodegenModel codegenModel = model.getModel();
                model.put("hasAllOf", codegenModel.allOf.size() > 0);
                model.put("hasOneOf", codegenModel.oneOf.size() > 0);
            }
        }
        return result;
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        codegenModel.additionalPropertiesType = this.getTypeDeclaration(ModelUtils.getAdditionalProperties(schema));
        this.addImport(codegenModel, codegenModel.additionalPropertiesType);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        List<ModelMap> models = this.postProcessModelsEnum(objs).getModels();
        boolean withoutPrefixEnums = false;
        if (this.additionalProperties.containsKey(WITHOUT_PREFIX_ENUMS)) {
            withoutPrefixEnums = Boolean.parseBoolean(this.additionalProperties.get(WITHOUT_PREFIX_ENUMS).toString());
        }
        for (ModelMap modelMap : models) {
            CodegenModel cm = modelMap.getModel();
            if (cm.getAdditionalPropertiesIsAnyType() && "any".equals(cm.getAdditionalPropertiesType())) {
                cm.setAdditionalPropertiesIsAnyType(false);
            }
            cm.classFilename = cm.classname.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
            if (withoutPrefixEnums) continue;
            cm.imports = new TreeSet<String>(cm.imports);
            for (CodegenProperty var : cm.vars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
            if (cm.parent == null) continue;
            for (CodegenProperty var : cm.allVars) {
                if (!Boolean.TRUE.equals(var.isEnum)) continue;
                var.datatypeWithEnum = var.datatypeWithEnum.replace(var.enumName, cm.classname + var.enumName);
                var.enumName = var.enumName.replace(var.enumName, cm.classname + var.enumName);
            }
        }
        for (Map<String, Object> map : objs.getImports()) {
            String javaImport = ((String)map.get("import")).substring(this.modelPackage.length() + 1);
            String tsImport = this.tsModelPackage + "/" + javaImport;
            map.put("tsImport", tsImport);
            map.put("class", javaImport);
            map.put("filename", javaImport.replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT));
        }
        return objs;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String toModelFilename(String name) {
        return super.toModelFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    @Override
    public String toApiFilename(String name) {
        return super.toApiFilename(name).replaceAll("([a-z0-9])([A-Z])", "$1-$2").toLowerCase(Locale.ROOT);
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
        if (this.supportsES6.booleanValue()) {
            this.supportingFiles.add(new SupportingFile("tsconfig.esm.mustache", "", "tsconfig.esm.json"));
        }
    }

    @Override
    protected void updatePropertyForAnyType(CodegenProperty property, Schema p) {
        if (this.languageSpecificPrimitives.contains(property.dataType)) {
            property.isPrimitiveType = true;
        }
        if (ModelUtils.isMapSchema(p)) {
            this.updatePropertyForMap(property, p);
        }
    }

    @Override
    protected void addImport(Schema composed, Schema childSchema, CodegenModel model, String modelName) {
        this.addImport(model, modelName);
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }
}

