/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractGoCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoGinServerCodegen
extends AbstractGoCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(GoGinServerCodegen.class);
    public static final String INTERFACE_ONLY = "interfaceOnly";
    protected boolean interfaceOnly = false;
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "openapi-server";
    protected String apiPath = "go";

    public GoGinServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code/go";
        this.modelTemplateFiles.put("model.mustache", ".go");
        this.apiTemplateFiles.put("controller-api.mustache", ".go");
        this.templateDir = "go-gin-server";
        this.embeddedTemplateDir = "go-gin-server";
        this.setReservedWordsLowerCase(Arrays.asList("string", "bool", "uint", "uint8", "uint16", "uint32", "uint64", "int", "int8", "int16", "int32", "int64", "float32", "float64", "complex64", "complex128", "rune", "byte", "uintptr", "break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var", "error", "nil"));
        this.cliOptions.add(new CliOption("apiPath", "Name of the folder that contains the Go source code").defaultValue(this.apiPath));
        this.cliOptions.add(CliOption.newBoolean(INTERFACE_ONLY, "Whether to generate only API interface stubs without the implementation files.", this.interfaceOnly));
        CliOption optServerPort = new CliOption("serverPort", "The network port the generated server binds to");
        optServerPort.setType("int");
        optServerPort.defaultValue(Integer.toString(this.serverPort));
        this.cliOptions.add(optServerPort);
        this.cliOptions.add(CliOption.newBoolean("enumClassPrefix", "Prefix enum with class name"));
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        OperationMap operations = objs.getOperations();
        List<CodegenOperation> operationList = operations.getOperation();
        for (CodegenOperation op : operationList) {
            if (op.path == null) continue;
            op.path = op.path.replaceAll("\\{(.*?)\\}", ":$1");
        }
        return objs;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
            this.additionalProperties.put("packageName", this.packageName);
        }
        if (this.additionalProperties.containsKey(INTERFACE_ONLY)) {
            this.setInterfaceOnly(Boolean.parseBoolean(this.additionalProperties.get(INTERFACE_ONLY).toString()));
        }
        if (this.additionalProperties.containsKey("apiVersion")) {
            this.apiVersion = (String)this.additionalProperties.get("apiVersion");
        } else {
            this.additionalProperties.put("apiVersion", this.apiVersion);
        }
        if (this.additionalProperties.containsKey("serverPort")) {
            this.serverPort = Integer.parseInt((String)this.additionalProperties.get("serverPort"));
        } else {
            this.additionalProperties.put("serverPort", this.serverPort);
        }
        if (this.additionalProperties.containsKey("apiPath")) {
            this.apiPath = (String)this.additionalProperties.get("apiPath");
        } else {
            this.additionalProperties.put("apiPath", this.apiPath);
        }
        if (this.additionalProperties.containsKey("enumClassPrefix")) {
            this.setEnumClassPrefix(Boolean.parseBoolean(this.additionalProperties.get("enumClassPrefix").toString()));
            if (this.enumClassPrefix) {
                this.additionalProperties.put("enumClassPrefix", true);
            }
        }
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        if (this.interfaceOnly) {
            this.apiTemplateFiles.clear();
            this.apiTemplateFiles.put("interface-api.mustache", ".go");
        }
        this.supportingFiles.add(new SupportingFile("openapi.mustache", "api", "openapi.yaml"));
        this.supportingFiles.add(new SupportingFile("main.mustache", "", "main.go"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("routers.mustache", this.apiPath, "routers.go"));
        this.supportingFiles.add(new SupportingFile("README.mustache", this.apiPath, "README.md").doNotOverwrite());
        this.supportingFiles.add(new SupportingFile("go.mod.mustache", "go.mod"));
    }

    @Override
    public String apiPackage() {
        return this.apiPath;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "go-gin-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Go server library with the gin framework using OpenAPI-Generator.By default, it will also generate service classes.";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public void setInterfaceOnly(boolean interfaceOnly) {
        this.interfaceOnly = interfaceOnly;
    }
}

