/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.servers.Server;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractJavaJAXRSServerCodegen;
import org.openapitools.codegen.languages.JavaHelidonCommonCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHelidonServerCodegen
extends JavaHelidonCommonCodegen {
    private final Logger LOGGER = LoggerFactory.getLogger(JavaHelidonServerCodegen.class);
    public static final String USE_ABSTRACT_CLASS = "useAbstractClass";
    public static final String GRADLE_PROJECT = "gradleProject";
    protected boolean useBeanValidation = true;
    protected String implFolder = "src/main/java";
    protected String serializationLibrary = null;
    private boolean useAbstractClass = false;
    private boolean gradleProject = false;

    public JavaHelidonServerCodegen() {
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}));
        this.outputFolder = "generated-code" + File.separator + "java";
        this.embeddedTemplateDir = this.templateDir = "java-helidon" + File.separator + "server";
        this.invokerPackage = "org.openapitools.server";
        this.artifactId = "openapi-java-server";
        this.apiPackage = this.invokerPackage + ".api";
        this.modelPackage = this.invokerPackage + ".model";
        this.sourceFolder = "src" + File.separator + "main" + File.separator + "java";
        this.updateOption("invokerPackage", this.getInvokerPackage());
        this.updateOption("artifactId", this.getArtifactId());
        this.updateOption("apiPackage", this.apiPackage);
        this.updateOption("modelPackage", this.modelPackage);
        this.modelTestTemplateFiles.put("model_test.mustache", ".java");
        this.cliOptions.add(CliOption.newBoolean("useBeanValidation", "Use Bean Validation"));
        this.cliOptions.add(CliOption.newBoolean("performBeanValidation", "Perform BeanValidation"));
        this.cliOptions.add(CliOption.newBoolean(USE_ABSTRACT_CLASS, "Whether to generate abstract classes for REST API instead of interfaces.", this.useAbstractClass));
        this.cliOptions.add(CliOption.newBoolean(GRADLE_PROJECT, "Whether to generate gradle project instead of maven.", this.gradleProject));
        this.modelDocTemplateFiles.remove("model_doc.mustache");
        this.apiDocTemplateFiles.remove("api_doc.mustache");
        this.apiTestTemplateFiles.clear();
        this.supportedLibraries.put("mp", "Helidon MP Server");
        this.supportedLibraries.put("se", "Helidon SE Server");
        CliOption libraryOption = new CliOption("library", "library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault("se");
        this.cliOptions.add(libraryOption);
        this.setLibrary("se");
        CliOption serializationLibrary = new CliOption("serializationLibrary", "Serialization library, defaults to Jackson");
        HashMap<String, String> serializationOptions = new HashMap<String, String>();
        serializationOptions.put("jackson", "Use Jackson as serialization library");
        serializationOptions.put("jsonb", "Use JSON-B as serialization library");
        serializationLibrary.setEnum(serializationOptions);
        this.cliOptions.add(serializationLibrary);
        this.setSerializationLibrary("jackson");
        this.removeUnusedOptions();
        this.setLegacyDiscriminatorBehavior(false);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.clear();
        this.dateLibrary = "java8";
        this.addApiTemplateFiles();
        SupportingFile pomFile = new SupportingFile("pom.mustache", "", "pom.xml");
        SupportingFile readmeFile = new SupportingFile("README.mustache", "", "README.md");
        SupportingFile openApiFile = new SupportingFile("openapi.mustache", "src/main/resources/META-INF".replace("/", File.separator), "openapi.yml");
        SupportingFile logFile = new SupportingFile("logging.mustache", "src.main.resources".replace(".", File.separator), "logging.properties");
        SupportingFile packageInfoFile = new SupportingFile("package-info.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "package-info.java");
        ArrayList<SupportingFile> modifiable = new ArrayList<SupportingFile>();
        modifiable.add(pomFile);
        modifiable.add(readmeFile);
        modifiable.add(logFile);
        modifiable.add(packageInfoFile);
        ArrayList<SupportingFile> unmodifiable = new ArrayList<SupportingFile>();
        unmodifiable.add(openApiFile);
        if (this.additionalProperties.containsKey("useBeanValidation")) {
            this.setUseBeanValidation(this.convertPropertyToBoolean("useBeanValidation"));
        }
        this.writePropertyBack("useBeanValidation", this.useBeanValidation);
        this.importMapping.put("ObjectMapper", "com.fasterxml.jackson.databind.ObjectMapper");
        this.importMapping.put("Jsonb", this.rootJavaEEPackage() + ".json.bind.Jsonb");
        this.importMapping.put("JsonbBuilder", this.rootJavaEEPackage() + ".json.bind.JsonbBuilder");
        if (this.additionalProperties.containsKey(USE_ABSTRACT_CLASS)) {
            this.useAbstractClass = Boolean.parseBoolean(this.additionalProperties.get(USE_ABSTRACT_CLASS).toString());
        }
        if (!this.useAbstractClass) {
            this.additionalProperties.remove(USE_ABSTRACT_CLASS);
        }
        if (this.additionalProperties.containsKey(GRADLE_PROJECT)) {
            this.gradleProject = Boolean.parseBoolean(this.additionalProperties.get(GRADLE_PROJECT).toString());
        }
        if (!this.gradleProject) {
            this.additionalProperties.remove(GRADLE_PROJECT);
        } else {
            modifiable.add(new SupportingFile("build.gradle.mustache", "", "build.gradle"));
            modifiable.add(new SupportingFile("settings.gradle.mustache", "", "settings.gradle"));
            modifiable.remove((Object)pomFile);
        }
        if (this.additionalProperties.containsKey("serializationLibrary")) {
            this.setSerializationLibrary(this.additionalProperties.get("serializationLibrary").toString());
        }
        String invokerFolder = (this.sourceFolder + "/" + this.invokerPackage).replace(".", "/");
        if (this.additionalProperties.containsKey("jsr310") && this.isLibrary("mp")) {
            this.supportingFiles.add(new SupportingFile("JavaTimeFormatter.mustache", invokerFolder, "JavaTimeFormatter.java"));
        }
        if (this.isLibrary("mp")) {
            String resourceFolder = "src" + File.separator + "main" + File.separator + "resources";
            String metaInfFolder = resourceFolder + File.separator + "META-INF";
            this.supportingFiles.add(new SupportingFile("RestApplication.mustache", invokerFolder, "RestApplication.java"));
            this.supportingFiles.add(new SupportingFile("microprofile-config.properties.mustache", metaInfFolder, "microprofile-config.properties"));
            this.supportingFiles.add(new SupportingFile("beans.xml.mustache", metaInfFolder, "beans.xml"));
            this.processSupportingFiles(modifiable, unmodifiable);
        } else if (this.isLibrary("se")) {
            this.artifactId = "openapi-helidon-se-server";
            modifiable.add(new SupportingFile("application.mustache", "src.main.resources".replace(".", File.separator), "application.yaml"));
            modifiable.add(new SupportingFile("mainTest.mustache", (this.testFolder + File.separator + this.invokerPackage).replace(".", File.separator), "MainTest.java"));
            modifiable.add(new SupportingFile("main.mustache", (this.sourceFolder + File.separator + this.invokerPackage).replace(".", File.separator), "Main.java"));
            unmodifiable.add(new SupportingFile("validatorUtils.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "ValidatorUtils.java"));
            if (this.useAbstractClass) {
                this.importMapping.put("Map", "java.util.Map");
                this.importMapping.put("HashMap", "java.util.HashMap");
                this.importMapping.put("InputStream", "java.io.InputStream");
                this.importMapping.put("ReadableBodyPart", "io.helidon.media.multipart.ReadableBodyPart");
                this.importMapping.put("ArrayList", "java.util.ArrayList");
                this.importMapping.put("ByteArrayOutputStream", "java.io.ByteArrayOutputStream");
                this.importMapping.put("DataChunk", "io.helidon.common.http.DataChunk");
                this.importMapping.put("UncheckedIOException", "java.io.UncheckedIOException");
                this.importMapping.put("IOException", "java.io.IOException");
                this.importMapping.put("ByteArrayInputStream", "java.io.ByteArrayInputStream");
            }
            this.importMapping.put("Handler", "io.helidon.webserver.Handler");
            this.processSupportingFiles(modifiable, unmodifiable);
        } else {
            this.LOGGER.error("Unknown library option (-l/--library): {}", (Object)this.getLibrary());
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown library option %s for Helidon Server", this.getLibrary()));
        }
        if (this.getSerializationLibrary() == null) {
            this.LOGGER.info("No serializationLibrary configured, using '{}' as fallback", (Object)"jackson");
            this.setSerializationLibrary("jackson");
        }
        switch (this.getSerializationLibrary()) {
            case "jackson": {
                this.additionalProperties.put("jackson", "true");
                this.additionalProperties.remove("jsonb");
                this.supportingFiles.add(new SupportingFile("RFC3339DateFormat.mustache", invokerFolder, "RFC3339DateFormat.java"));
                if (!this.isLibrary("se")) break;
                this.supportingFiles.add(new SupportingFile("jsonProvider.mustache", (this.sourceFolder + File.separator + this.apiPackage).replace(".", File.separator), "JsonProvider.java"));
                break;
            }
            case "jsonb": {
                this.openApiNullable = false;
                this.additionalProperties.put("openApiNullable", false);
                this.additionalProperties.put("jsonb", "true");
                this.additionalProperties.remove("jackson");
                break;
            }
            default: {
                this.additionalProperties.remove("jackson");
                this.additionalProperties.remove("jsonb");
                this.LOGGER.error("Unknown serialization library option");
            }
        }
    }

    private void addApiTemplateFiles() {
        Boolean fullProject;
        Boolean bl = fullProject = !this.additionalProperties.containsKey("fullProject") ? null : Boolean.valueOf(Boolean.parseBoolean(this.additionalProperties.get("fullProject").toString()));
        if (fullProject == null && !this.projectFilesExist()) {
            this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
        } else if (Boolean.TRUE.equals(fullProject)) {
            this.apiTemplateFiles.put("apiImpl.mustache", "Impl.java");
        }
    }

    @Override
    public CodegenOperation fromOperation(String path, String httpMethod, Operation operation, List<Server> servers) {
        CodegenOperation codegenOperation = super.fromOperation(path, httpMethod, operation, servers);
        if ("se".equals(this.getLibrary())) {
            if (this.additionalProperties.containsKey("jackson")) {
                codegenOperation.imports.add("ObjectMapper");
            }
            if (this.additionalProperties.containsKey("jsonb")) {
                codegenOperation.imports.add("Jsonb");
                codegenOperation.imports.add("JsonbBuilder");
            }
            if (codegenOperation.bodyParam != null) {
                codegenOperation.imports.add("Handler");
            }
            if (codegenOperation.queryParams.size() > 0 && this.useAbstractClass) {
                codegenOperation.imports.add("List");
            }
            if (codegenOperation.formParams.size() > 0 && this.useAbstractClass) {
                codegenOperation.imports.add("Map");
                codegenOperation.imports.add("HashMap");
                codegenOperation.imports.add("InputStream");
                codegenOperation.imports.add("ReadableBodyPart");
                codegenOperation.imports.add("ArrayList");
                codegenOperation.imports.add("DataChunk");
                codegenOperation.imports.add("ByteArrayOutputStream");
                codegenOperation.imports.add("IOException");
                codegenOperation.imports.add("UncheckedIOException");
                codegenOperation.imports.add("ByteArrayInputStream");
            }
        }
        return codegenOperation;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        this.generateYAMLSpecFile(objs);
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultService";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name) + "Service";
    }

    @Override
    public CodegenModel fromModel(String name, Schema model) {
        CodegenModel codegenModel = super.fromModel(name, model);
        codegenModel.imports.remove("ApiModelProperty");
        codegenModel.imports.remove("ApiModel");
        return codegenModel;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if ("mp".equals(this.getLibrary())) {
            return AbstractJavaJAXRSServerCodegen.jaxrsPostProcessOperations(objs);
        }
        if (operations != null && "se".equals(this.getLibrary())) {
            List<CodegenOperation> ops = operations.getOperation();
            for (CodegenOperation operation : ops) {
                if (operation.formParams.size() <= 0) continue;
                objs.put("isFormParamsFunctions", true);
            }
        }
        return objs;
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (Boolean.TRUE.equals(model.hasEnums) && this.additionalProperties.containsKey("jackson")) {
            model.imports.add("JsonValue");
            model.imports.add("JsonCreator");
        }
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "java-helidon-server";
    }

    @Override
    public String getHelp() {
        return "Generates a Java Helidon Server application.";
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setPerformBeanValidation(boolean performBeanValidation) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getSerializationLibrary() {
        return this.serializationLibrary;
    }

    public void setSerializationLibrary(String serializationLibrary) {
        if ("jackson".equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = "jackson";
        } else if ("jsonb".equalsIgnoreCase(serializationLibrary)) {
            this.serializationLibrary = "jsonb";
        } else {
            throw new IllegalArgumentException("Unexpected serializationLibrary value: " + serializationLibrary);
        }
    }

    @Override
    protected boolean projectFilesExist() {
        Path projectFolder = Paths.get(this.getOutputTestFolder(), new String[0]);
        Path pom = projectFolder.resolve("pom.xml");
        Path buildGradle = projectFolder.resolve("build.gradle");
        Path src = projectFolder.resolve(Paths.get(this.sourceFolder, this.invokerPackage.replace('.', File.separatorChar)));
        return (pom.toFile().exists() || buildGradle.toFile().exists()) && src.toFile().exists();
    }
}

