/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.ClientModificationFeature;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.CamelizeOption;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RClientCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(RClientCodegen.class);
    protected String packageName = "openapi";
    protected String packageVersion = "1.0.0";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";
    protected String testFolder = "tests/testthat";
    protected boolean returnExceptionOnFailure = false;
    protected String exceptionPackage = "default";
    protected Map<String, String> exceptionPackages = new LinkedHashMap<String, String>();
    protected Set<String> itemReservedWords = new TreeSet<String>();
    public static final String EXCEPTION_PACKAGE = "exceptionPackage";
    public static final String USE_DEFAULT_EXCEPTION = "useDefaultExceptionHandling";
    public static final String USE_RLANG_EXCEPTION = "useRlangExceptionHandling";
    public static final String GENERATE_WRAPPER = "generateWrapper";
    public static final String DEFAULT = "default";
    public static final String RLANG = "rlang";
    public static final String HTTR = "httr";
    public static final String HTTR2 = "httr2";
    public static final String OPERATIONID_NAMING = "operationIdNaming";
    protected boolean useDefaultExceptionHandling = false;
    protected boolean useRlangExceptionHandling = false;
    protected String errorObjectType;
    protected String operationIdNaming;
    protected boolean generateWrapper;
    protected boolean useOneOfDiscriminatorLookup = false;
    private Map<String, String> schemaKeyToModelNameCache = new HashMap<String, String>();

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "r";
    }

    @Override
    public String getHelp() {
        return "Generates a R client library (beta).";
    }

    public RClientCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML, WireFormatFeature.Custom)).securityFeatures(EnumSet.of(SecurityFeature.BasicAuth, SecurityFeature.ApiKey, SecurityFeature.OAuth2_Implicit, SecurityFeature.BearerToken)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}).includeClientModificationFeatures(new ClientModificationFeature[]{ClientModificationFeature.BasePath, ClientModificationFeature.UserAgent}));
        this.outputFolder = "generated-code/r";
        this.modelTemplateFiles.put("model.mustache", ".R");
        this.apiTemplateFiles.put("api.mustache", ".R");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.templateDir = "r";
        this.embeddedTemplateDir = "r";
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("if", "else", "repeat", "while", "function", "for", "in", "next", "break", "TRUE", "FALSE", "NULL", "Inf", "NaN", "NA", "NA_integer_", "NA_real_", "NA_complex_", "NA_character_", "ApiResponse", "data_file"));
        this.itemReservedWords.add("self");
        this.itemReservedWords.add("private");
        this.itemReservedWords.add("super");
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("integer");
        this.languageSpecificPrimitives.add("numeric");
        this.languageSpecificPrimitives.add("character");
        this.languageSpecificPrimitives.add("data.frame");
        this.languageSpecificPrimitives.add("object");
        this.typeMapping.clear();
        this.typeMapping.put("integer", "integer");
        this.typeMapping.put("long", "integer");
        this.typeMapping.put("number", "numeric");
        this.typeMapping.put("float", "numeric");
        this.typeMapping.put("double", "numeric");
        this.typeMapping.put("decimal", "numeric");
        this.typeMapping.put("boolean", "character");
        this.typeMapping.put("string", "character");
        this.typeMapping.put("UUID", "character");
        this.typeMapping.put("URI", "character");
        this.typeMapping.put("date", "character");
        this.typeMapping.put("DateTime", "character");
        this.typeMapping.put("password", "character");
        this.typeMapping.put("file", "data.frame");
        this.typeMapping.put("binary", "data.frame");
        this.typeMapping.put("ByteArray", "character");
        this.typeMapping.put("map", "map");
        this.typeMapping.put("object", "object");
        this.importMapping.clear();
        this.cliOptions.clear();
        this.cliOptions.add(new CliOption("packageName", "R package name (convention: lowercase).").defaultValue("openapi"));
        this.cliOptions.add(new CliOption("packageVersion", "R package version.").defaultValue("1.0.0"));
        this.cliOptions.add(new CliOption("hideGenerationTimestamp", "Hides the generation timestamp when files are generated.").defaultValue(Boolean.TRUE.toString()));
        this.cliOptions.add(new CliOption("returnExceptionOnFailure", "Throw an exception on non success response codes").defaultValue(Boolean.FALSE.toString()));
        CliOption operationIdNaming = CliOption.newString(OPERATIONID_NAMING, "Naming convention for operationId (function name in the API)");
        HashMap<String, String> operationIdNamingOptions = new HashMap<String, String>();
        operationIdNamingOptions.put("snake_case", "Snake case");
        operationIdNamingOptions.put("camelCase", "Camel case");
        operationIdNamingOptions.put("PascalCase", "Pascal case (default)");
        operationIdNaming.setEnum(operationIdNamingOptions);
        this.cliOptions.add(operationIdNaming);
        this.exceptionPackages.put(DEFAULT, "Use stop() for raising exceptions.");
        this.exceptionPackages.put(RLANG, "Use rlang package for exceptions.");
        CliOption exceptionPackage = new CliOption(EXCEPTION_PACKAGE, "Specify the exception handling package");
        exceptionPackage.setEnum(this.exceptionPackages);
        exceptionPackage.setDefault(DEFAULT);
        this.cliOptions.add(exceptionPackage);
        this.cliOptions.add(CliOption.newString("errorObjectType", "Error object type."));
        this.supportedLibraries.put(HTTR2, "httr2 (https://httr2.r-lib.org/)");
        this.supportedLibraries.put(HTTR, "httr (https://cran.r-project.org/web/packages/httr/index.html)");
        CliOption libraryOption = new CliOption("library", "HTTP library template (sub-template) to use");
        libraryOption.setEnum(this.supportedLibraries);
        libraryOption.setDefault(HTTR);
        this.cliOptions.add(libraryOption);
        this.setLibrary(HTTR);
        this.cliOptions.add(CliOption.newBoolean(GENERATE_WRAPPER, "Generate a wrapper class (single point of access) for the R client. This option only works with `httr2` library."));
        CliOption disallowAdditionalPropertiesIfNotPresentOpt = CliOption.newBoolean("disallowAdditionalPropertiesIfNotPresent", "If false, the 'additionalProperties' implementation (set to true by default) is compliant with the OAS and JSON schema specifications. If true (default), keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.").defaultValue(Boolean.TRUE.toString());
        HashMap<String, String> disallowAdditionalPropertiesIfNotPresentOpts = new HashMap<String, String>();
        disallowAdditionalPropertiesIfNotPresentOpts.put("false", "The 'additionalProperties' implementation is compliant with the OAS and JSON schema specifications.");
        disallowAdditionalPropertiesIfNotPresentOpts.put("true", "Keep the old (incorrect) behaviour that 'additionalProperties' is set to false by default.");
        disallowAdditionalPropertiesIfNotPresentOpt.setEnum(disallowAdditionalPropertiesIfNotPresentOpts);
        this.cliOptions.add(disallowAdditionalPropertiesIfNotPresentOpt);
        this.setDisallowAdditionalPropertiesIfNotPresent(true);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey("packageName")) {
            this.setPackageName((String)this.additionalProperties.get("packageName"));
        } else {
            this.setPackageName("openapi");
        }
        if (this.additionalProperties.containsKey("packageVersion")) {
            this.setPackageVersion((String)this.additionalProperties.get("packageVersion"));
        } else {
            this.setPackageVersion("1.0.0");
        }
        if (this.additionalProperties.containsKey("returnExceptionOnFailure")) {
            this.setReturnExceptionOnFailure(Boolean.parseBoolean(this.additionalProperties.get("returnExceptionOnFailure").toString()));
        } else {
            this.setReturnExceptionOnFailure(false);
        }
        if (this.additionalProperties.containsKey(EXCEPTION_PACKAGE)) {
            this.setExceptionPackageToUse(this.additionalProperties.get(EXCEPTION_PACKAGE).toString());
        } else {
            this.setExceptionPackageToUse(DEFAULT);
        }
        if (this.additionalProperties.containsKey("errorObjectType")) {
            this.setErrorObjectType(this.additionalProperties.get("errorObjectType").toString());
        }
        this.additionalProperties.put("errorObjectType", this.errorObjectType);
        if (this.additionalProperties.containsKey(OPERATIONID_NAMING)) {
            this.setOperationIdNaming(this.additionalProperties.get(OPERATIONID_NAMING).toString());
        } else {
            this.setOperationIdNaming("PascalCase");
        }
        this.additionalProperties.put("errorObjectType", this.errorObjectType);
        if (this.additionalProperties.containsKey(GENERATE_WRAPPER)) {
            this.setGenerateWrapper(Boolean.parseBoolean(this.additionalProperties.get(GENERATE_WRAPPER).toString()));
        } else {
            this.setGenerateWrapper(false);
        }
        if (this.additionalProperties.containsKey("useOneOfDiscriminatorLookup")) {
            this.setUseOneOfDiscriminatorLookup(this.convertPropertyToBooleanAndWriteBack("useOneOfDiscriminatorLookup"));
        } else {
            this.additionalProperties.put("useOneOfDiscriminatorLookup", this.useOneOfDiscriminatorLookup);
        }
        if (this.additionalProperties.containsKey("disallowAdditionalPropertiesIfNotPresent")) {
            this.setDisallowAdditionalPropertiesIfNotPresent(Boolean.parseBoolean(this.additionalProperties.get("disallowAdditionalPropertiesIfNotPresent").toString()));
        }
        this.additionalProperties.put("packageName", this.packageName);
        this.additionalProperties.put("packageVersion", this.packageVersion);
        this.additionalProperties.put("returnExceptionOnFailure", this.returnExceptionOnFailure);
        this.additionalProperties.put(USE_DEFAULT_EXCEPTION, this.useDefaultExceptionHandling);
        this.additionalProperties.put(USE_RLANG_EXCEPTION, this.useRlangExceptionHandling);
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        this.modelTestTemplateFiles.put("model_test.mustache", ".R");
        this.apiTestTemplateFiles.put("api_test.mustache", ".R");
        this.modelDocTemplateFiles.put("model_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.modelPackage = this.packageName;
        this.apiPackage = this.packageName;
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("description.mustache", "", "DESCRIPTION"));
        this.supportingFiles.add(new SupportingFile("Rbuildignore.mustache", "", ".Rbuildignore"));
        this.supportingFiles.add(new SupportingFile(".travis.yml.mustache", "", ".travis.yml"));
        this.supportingFiles.add(new SupportingFile("ApiResponse.mustache", File.separator + "R", "api_response.R"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", File.separator + "R", "api_client.R"));
        this.supportingFiles.add(new SupportingFile("NAMESPACE.mustache", "", "NAMESPACE"));
        this.supportingFiles.add(new SupportingFile("testthat.mustache", File.separator + "tests", "testthat.R"));
        this.supportingFiles.add(new SupportingFile("r-client.mustache", File.separator + ".github" + File.separator + "workflows", "r-client.yaml"));
        this.supportingFiles.add(new SupportingFile("lintr.mustache", "", ".lintr"));
        if (HTTR.equals(this.getLibrary())) {
            this.setLibrary(HTTR);
        } else if (HTTR2.equals(this.getLibrary())) {
            this.setLibrary(HTTR2);
            this.additionalProperties.put("isHttr2", Boolean.TRUE);
            if (this.generateWrapper) {
                this.supportingFiles.add(new SupportingFile("api_wrapper.mustache", "R", this.packageName.toLowerCase(Locale.ROOT) + "_api.R"));
            }
        } else {
            throw new IllegalArgumentException("Invalid HTTP library " + this.getLibrary() + ". Only httr, httr2 are supported.");
        }
        this.additionalProperties.put("lambdaLicense", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replace("Apache-2.0", "Apache License 2.0");
                writer.write(content);
            }
        });
        this.additionalProperties.put("lambdaRdocEscape", new Mustache.Lambda(){

            public void execute(Template.Fragment fragment, Writer writer) throws IOException {
                String content = fragment.execute();
                content = content.trim().replace("%", "\\%");
                writer.write(content);
            }
        });
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return StringUtils.camelize(name) + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + "R" + File.separator;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + "R" + File.separator;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        if (((String)(name = this.sanitizeName(((String)name).replaceAll("-", "_")))).matches("^[A-Z_]*$")) {
            return name;
        }
        if (this.isReservedWord((String)(name = StringUtils.underscore((String)name)))) {
            name = "var_" + (String)name;
        }
        if (((String)name).matches("^\\d.*")) {
            name = "var_" + (String)name;
        }
        return name;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        if (this.itemReservedWords.contains(name)) {
            this.LOGGER.info("The item `{}` has been renamed to `item_{}` as it's a reserved word.", (Object)name, (Object)name);
            return "item_" + name;
        }
        if ("".equals(name)) {
            this.LOGGER.warn("Empty item name `` (empty string) has been renamed to `empty_string` to avoid compilation errors.");
            return "empty_string";
        }
        return name;
    }

    @Override
    public String toModelFilename(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return StringUtils.underscore((String)this.modelNameMapping.get(name));
        }
        return StringUtils.underscore(this.toModelName(name));
    }

    @Override
    public String toModelName(String name) {
        if (this.modelNameMapping.containsKey(name)) {
            return (String)this.modelNameMapping.get(name);
        }
        if (this.schemaMapping.containsKey(name)) {
            return (String)this.schemaMapping.get(name);
        }
        Object origName = name;
        if (this.schemaKeyToModelNameCache.containsKey(origName)) {
            return this.schemaKeyToModelNameCache.get(origName);
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNamePrefix)) {
            name = this.modelNamePrefix + "_" + (String)name;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.modelNameSuffix)) {
            name = (String)name + "_" + this.modelNameSuffix;
        }
        if (this.isReservedWord((String)(name = this.sanitizeName((String)name)))) {
            this.LOGGER.warn("{} (reserved word) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = "model_" + (String)name;
        }
        if (((String)name).matches("^\\d.*")) {
            this.LOGGER.warn("{} (model name starts with number) cannot be used as model name. Renamed to {}", name, (Object)StringUtils.camelize("model_" + (String)name));
            name = "model_" + (String)name;
        }
        this.schemaKeyToModelNameCache.put((String)origName, StringUtils.camelize((String)name));
        return StringUtils.camelize((String)name);
    }

    @Override
    public String toApiFilename(String name) {
        name = name.replaceAll("-", "_");
        return StringUtils.underscore(name + "_api");
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toModelDocFilename(String name) {
        return this.toModelName(name);
    }

    @Override
    public String toApiDocFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String toApiName(String name) {
        return StringUtils.camelize(super.toApiName(name));
    }

    @Override
    public String getTypeDeclaration(Schema p) {
        if (ModelUtils.isArraySchema(p)) {
            ArraySchema ap = (ArraySchema)p;
            Schema inner = ap.getItems();
            return this.getSchemaType(p) + "[" + this.getTypeDeclaration(inner) + "]";
        }
        if (ModelUtils.isMapSchema(p)) {
            Schema inner = ModelUtils.getAdditionalProperties(p);
            return this.getSchemaType(p) + "(" + this.getTypeDeclaration(inner) + ")";
        }
        String openAPIType = this.getSchemaType(p);
        if (this.typeMapping.containsKey(openAPIType)) {
            return (String)this.typeMapping.get(openAPIType);
        }
        if (this.typeMapping.containsValue(openAPIType)) {
            return openAPIType;
        }
        if (this.languageSpecificPrimitives.contains(openAPIType)) {
            return openAPIType;
        }
        return this.toModelName(openAPIType);
    }

    @Override
    public String getSchemaType(Schema p) {
        String openAPIType = super.getSchemaType(p);
        String type = null;
        if (this.typeMapping.containsKey(openAPIType)) {
            type = (String)this.typeMapping.get(openAPIType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = openAPIType;
        }
        return type;
    }

    @Override
    public String toOperationId(String operationId) {
        Object sanitizedOperationId = this.sanitizeName(operationId);
        if (this.isReservedWord((String)sanitizedOperationId)) {
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)StringUtils.underscore("call_" + operationId));
            sanitizedOperationId = "call_" + (String)sanitizedOperationId;
        }
        if ("PascalCase".equals(this.operationIdNaming)) {
            return StringUtils.camelize((String)sanitizedOperationId);
        }
        if ("camelCase".equals(this.operationIdNaming)) {
            return StringUtils.camelize((String)sanitizedOperationId, CamelizeOption.LOWERCASE_FIRST_LETTER);
        }
        if ("snake_case".equals(this.operationIdNaming)) {
            return StringUtils.underscore((String)sanitizedOperationId);
        }
        this.LOGGER.error("Invalid operationIdNaming: {}. Please report the issue. Default to PascalCase for the time being", (Object)this.operationIdNaming);
        return StringUtils.camelize((String)sanitizedOperationId);
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        for (ModelMap mo : objs.getModels()) {
            CodegenModel cm = mo.getModel();
            for (CodegenProperty var : cm.vars) {
                if ("".equals(var.baseName)) {
                    this.LOGGER.debug("Empty baseName `` (empty string) in the model `{}` has been renamed to `empty_string` to avoid compilation errors.", (Object)cm.classname);
                    var.baseName = "empty_string";
                }
                var.vendorExtensions.put("x-r-doc-type", this.constructRdocType(var));
            }
            for (CodegenProperty var : cm.allVars) {
                if ("".equals(var.baseName)) {
                    this.LOGGER.debug("Empty baseName `` (empty string) in the model `{}` has been renamed to `empty_string` to avoid compilation errors.", (Object)cm.classname);
                    var.baseName = "empty_string";
                }
                var.vendorExtensions.put("x-r-doc-type", this.constructRdocType(var));
            }
        }
        return this.postProcessModelsEnum(objs);
    }

    @Override
    protected boolean needToImport(String type) {
        return !this.languageSpecificPrimitives.contains(type);
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public void setReturnExceptionOnFailure(boolean returnExceptionOnFailure) {
        this.returnExceptionOnFailure = returnExceptionOnFailure;
    }

    public void setExceptionPackageToUse(String exceptionPackage) {
        if (DEFAULT.equals(exceptionPackage)) {
            this.useDefaultExceptionHandling = true;
        }
        if (RLANG.equals(exceptionPackage)) {
            this.supportingFiles.add(new SupportingFile("api_exception.mustache", File.separator + "R", "api_exception.R"));
            this.useRlangExceptionHandling = true;
        }
    }

    public void setErrorObjectType(String errorObjectType) {
        this.errorObjectType = errorObjectType;
    }

    public void setGenerateWrapper(boolean generateWrapper) {
        this.generateWrapper = generateWrapper;
    }

    public void setUseOneOfDiscriminatorLookup(boolean useOneOfDiscriminatorLookup) {
        this.useOneOfDiscriminatorLookup = useOneOfDiscriminatorLookup;
    }

    public boolean getUseOneOfDiscriminatorLookup() {
        return this.useOneOfDiscriminatorLookup;
    }

    public void setOperationIdNaming(String operationIdNaming) {
        if (!("PascalCase".equals(operationIdNaming) || "camelCase".equals(operationIdNaming) || "snake_case".equals(operationIdNaming))) {
            throw new IllegalArgumentException("Invalid operationIdNaming: " + operationIdNaming + ". Must be PascalCase, camelCase or snake_case");
        }
        if ("snake_case".equals(operationIdNaming)) {
            this.additionalProperties.put("WithHttpInfo", "_with_http_info");
        } else {
            this.additionalProperties.put("WithHttpInfo", "WithHttpInfo");
        }
        this.operationIdNaming = operationIdNaming;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("]]", "] ]");
    }

    public Map<String, String> createMapping(String key, String value) {
        HashMap<String, String> customImport = new HashMap<String, String>();
        customImport.put(key, value);
        return customImport;
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            return value;
        }
        return this.escapeText(value);
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "_" + value;
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "EMPTY";
        }
        if ("int".equals(datatype) || "double".equals(datatype) || "float".equals(datatype)) {
            String varName = name;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        if (this.getSymbolName(name) != null) {
            return this.getSymbolName(name).toUpperCase(Locale.ROOT);
        }
        String enumName = this.sanitizeName(StringUtils.underscore(name).toUpperCase(Locale.ROOT));
        enumName = enumName.replaceFirst("^_", "");
        if (this.isReservedWord(enumName = enumName.replaceFirst("_$", "")) || enumName.matches("\\d.*")) {
            return this.escapeReservedWord(enumName);
        }
        return enumName;
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        String enumName = StringUtils.underscore(this.toModelName(property.name)).toUpperCase(Locale.ROOT);
        if ((enumName = enumName.replace("[]", "")).matches("\\d.*")) {
            return "_" + enumName;
        }
        return enumName;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter p) {
        if (p.defaultValue != null) {
            p.example = p.defaultValue;
            return;
        }
        Object example = p.example;
        String type = p.baseType;
        if (type == null) {
            type = p.dataType;
        }
        if ("character".equals(type)) {
            if (example == null) {
                example = p.paramName + "_example";
            }
            example = "\"" + this.escapeText((String)example) + "\"";
        } else if ("integer".equals(type)) {
            if (example == null) {
                example = "56";
            }
        } else if ("numeric".equals(type)) {
            if (example == null) {
                example = "3.4";
            }
        } else if ("data.frame".equals(type)) {
            if (example == null) {
                example = "/path/to/file";
            }
            example = "File.new('" + this.escapeText((String)example) + "')";
        } else if (!this.languageSpecificPrimitives.contains(type)) {
            example = type + "$new()";
        }
        if (example == null) {
            example = "NULL";
        } else if (Boolean.TRUE.equals(p.isArray)) {
            example = "[" + (String)example + "]";
        } else if (Boolean.TRUE.equals(p.isMap)) {
            example = "{'key' => " + (String)example + "}";
        }
        p.example = example;
    }

    @Override
    public void setParameterExampleValue(CodegenParameter codegenParameter, Parameter parameter) {
        if (parameter.getExample() != null) {
            codegenParameter.example = parameter.getExample().toString();
        } else if (parameter.getExamples() != null && !parameter.getExamples().isEmpty()) {
            Example example = (Example)parameter.getExamples().values().iterator().next();
            if (example.getValue() != null) {
                codegenParameter.example = example.getValue().toString();
            }
        } else {
            Schema schema = parameter.getSchema();
            if (schema != null && schema.getExample() != null) {
                codegenParameter.example = schema.getExample().toString();
            }
        }
        this.setParameterExampleValue(codegenParameter);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                if (!Boolean.valueOf(p.getDefault().toString()).booleanValue()) {
                    return "FALSE";
                }
                return "TRUE";
            }
        } else if (ModelUtils.isDateSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + String.valueOf(p.getDefault()).replaceAll("\"", "\\\"") + "\"";
            }
        } else if (ModelUtils.isDateTimeSchema(p)) {
            if (p.getDefault() != null) {
                return "\"" + String.valueOf(p.getDefault()).replaceAll("\"", "\\\"") + "\"";
            }
        } else if (ModelUtils.isNumberSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isIntegerSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p)) {
            if (p.getDefault() != null) {
                if (Pattern.compile("\r\n|\r|\n").matcher(String.valueOf(p.getDefault())).find()) {
                    return "'''" + p.getDefault().toString() + "'''";
                }
                return "\"" + String.valueOf(p.getDefault()).replaceAll("\"", "\\\"") + "\"";
            }
        } else if (ModelUtils.isArraySchema(p) && p.getDefault() != null) {
            return p.getDefault().toString();
        }
        return null;
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder;
    }

    @Override
    public String modelTestFileFolder() {
        return this.outputFolder + File.separator + this.testFolder;
    }

    @Override
    public String toApiTestFilename(String name) {
        return "test_" + this.toApiFilename(name);
    }

    @Override
    public String toModelTestFilename(String name) {
        return "test_" + this.toModelFilename(name);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        HashMap<String, CodegenModel> modelMaps = new HashMap<String, CodegenModel>();
        for (ModelMap modelMap : allModels) {
            CodegenModel m = modelMap.getModel();
            modelMaps.put(m.classname, m);
        }
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation operation : operations) {
            for (CodegenParameter cp : operation.allParams) {
                cp.vendorExtensions.put("x-r-example", this.constructExampleCode(cp, modelMaps));
            }
        }
        return objs;
    }

    public String constructRdocType(CodegenProperty codegenProperty) {
        if (codegenProperty.isArray) {
            return "list(" + this.constructRdocType(codegenProperty.items) + ")";
        }
        if (codegenProperty.isMap) {
            return "named list(" + this.constructRdocType(codegenProperty.items) + ")";
        }
        if (this.languageSpecificPrimitives.contains(codegenProperty.dataType)) {
            return codegenProperty.dataType;
        }
        return "\\link{" + codegenProperty.dataType + "}";
    }

    public String constructExampleCode(CodegenParameter codegenParameter, HashMap<String, CodegenModel> modelMaps) {
        if (codegenParameter.isArray) {
            return "c(" + this.constructExampleCode(codegenParameter.items, modelMaps, 0) + ")";
        }
        if (codegenParameter.isMap) {
            return "c(key = " + this.constructExampleCode(codegenParameter.items, modelMaps, 0) + ")";
        }
        if (this.languageSpecificPrimitives.contains(codegenParameter.dataType)) {
            return codegenParameter.example;
        }
        if (modelMaps.containsKey(codegenParameter.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenParameter.dataType), modelMaps, 0);
        }
        this.LOGGER.error("Error in constructing examples. Failed to look up the model {}", (Object)codegenParameter.dataType);
        return "TODO";
    }

    public String constructExampleCode(CodegenProperty codegenProperty, HashMap<String, CodegenModel> modelMaps, int depth) {
        if (depth > 10) {
            return "...";
        }
        ++depth;
        if (codegenProperty == null) {
            return "TODO";
        }
        if (codegenProperty.isArray) {
            return "c(" + this.constructExampleCode(codegenProperty.items, modelMaps, depth) + ")";
        }
        if (codegenProperty.isMap) {
            return "c(key = " + this.constructExampleCode(codegenProperty.items, modelMaps, depth) + ")";
        }
        if (this.languageSpecificPrimitives.contains(codegenProperty.dataType)) {
            if ("character".equals(codegenProperty.dataType)) {
                if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                    return "\"" + codegenProperty.example + "\"";
                }
                if (Boolean.TRUE.equals(codegenProperty.isEnum)) {
                    return "\"" + ((List)codegenProperty.allowableValues.get("values")).get(0) + "\"";
                }
                return "\"" + codegenProperty.name + "_example\"";
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)codegenProperty.example)) {
                return codegenProperty.example;
            }
            return "123";
        }
        if (modelMaps.containsKey(codegenProperty.dataType)) {
            return this.constructExampleCode(modelMaps.get(codegenProperty.dataType), modelMaps, depth);
        }
        this.LOGGER.error("Error in constructing examples. Failed to look up the model {}", (Object)codegenProperty.dataType);
        return "TODO";
    }

    public String constructExampleCode(CodegenModel codegenModel, HashMap<String, CodegenModel> modelMaps, int depth) {
        if (depth > 10) {
            return "...";
        }
        ++depth;
        String example = codegenModel.name + "$new(";
        ArrayList<String> propertyExamples = new ArrayList<String>();
        for (CodegenProperty codegenProperty : codegenModel.requiredVars) {
            propertyExamples.add(this.constructExampleCode(codegenProperty, modelMaps, depth));
        }
        for (CodegenProperty codegenProperty : codegenModel.optionalVars) {
            propertyExamples.add(this.constructExampleCode(codegenProperty, modelMaps, depth));
        }
        example = example + org.apache.commons.lang3.StringUtils.join(propertyExamples, (String)", ");
        example = example + ")";
        return example;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                          #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                 #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                          #");
        System.out.println("#                                                                              #");
        System.out.println("# This generator has been refactored by wing328 (https://github.com/wing328)   #");
        System.out.println("# Please support his work directly by purchasing a copy of the eBook \ud83d\udcd8        #");
        System.out.println("# - OpenAPI Generator for R Developers                http://bit.ly/3lpywTG    #");
        System.out.println("################################################################################");
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.R;
    }

    @Override
    public String toRegularExpression(String pattern) {
        if (pattern == null) {
            return null;
        }
        if (pattern.charAt(0) == '/') {
            pattern = pattern.substring(1);
        }
        if (pattern.charAt(pattern.length() - 1) == '/') {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        return this.escapeText(pattern);
    }
}

