/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.collect.ImmutableMap;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergedSpecBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MergedSpecBuilder.class);
    private final String inputSpecRootDirectory;
    private final String mergeFileName;

    public MergedSpecBuilder(String rootDirectory, String mergeFileName) {
        this.inputSpecRootDirectory = rootDirectory;
        this.mergeFileName = mergeFileName;
    }

    public String buildMergedSpec() {
        this.deleteMergedFileFromPreviousRun();
        List<String> specRelatedPaths = this.getAllSpecFilesInDirectory();
        if (specRelatedPaths.isEmpty()) {
            throw new RuntimeException("Spec directory doesn't contains any specification");
        }
        LOGGER.info("In spec root directory {} found specs {}", (Object)this.inputSpecRootDirectory, specRelatedPaths);
        String openapiVersion = null;
        boolean isJson = false;
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        ArrayList<SpecWithPaths> allPaths = new ArrayList<SpecWithPaths>();
        for (String specRelatedPath : specRelatedPaths) {
            String specPath = this.inputSpecRootDirectory + File.separator + specRelatedPath;
            try {
                LOGGER.info("Reading spec: {}", (Object)specPath);
                OpenAPI result = new OpenAPIParser().readLocation(specPath, new ArrayList(), options).getOpenAPI();
                if (openapiVersion == null) {
                    openapiVersion = result.getOpenapi();
                    if (specRelatedPath.toLowerCase(Locale.ROOT).endsWith(".json")) {
                        isJson = true;
                    }
                }
                allPaths.add(new SpecWithPaths(specRelatedPath, result.getPaths().keySet()));
            }
            catch (Exception e) {
                LOGGER.error("Failed to read file: {}. It would be ignored", (Object)specPath);
            }
        }
        Map<String, Object> mergedSpec = MergedSpecBuilder.generatedMergedSpec(openapiVersion, allPaths);
        String mergedFilename = this.mergeFileName + (isJson ? ".json" : ".yaml");
        Path mergedFilePath = Paths.get(this.inputSpecRootDirectory, mergedFilename);
        try {
            ObjectMapper objectMapper = isJson ? new ObjectMapper() : new ObjectMapper((JsonFactory)new YAMLFactory());
            Files.write(mergedFilePath, objectMapper.writeValueAsBytes(mergedSpec), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return mergedFilePath.toString();
    }

    private static Map<String, Object> generatedMergedSpec(String openapiVersion, List<SpecWithPaths> allPaths) {
        Map<String, Object> spec = MergedSpecBuilder.generateHeader(openapiVersion);
        HashMap<String, ImmutableMap> paths = new HashMap<String, ImmutableMap>();
        spec.put("paths", paths);
        for (SpecWithPaths specWithPaths : allPaths) {
            for (String path : specWithPaths.paths) {
                String specRelatedPath = "./" + specWithPaths.specRelatedPath + "#/paths/" + path.replace("/", "~1");
                paths.put(path, ImmutableMap.of((Object)"$ref", (Object)specRelatedPath));
            }
        }
        return spec;
    }

    private static Map<String, Object> generateHeader(String openapiVersion) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("openapi", openapiVersion);
        map.put("info", ImmutableMap.of((Object)"title", (Object)"merged spec", (Object)"description", (Object)"merged spec", (Object)"version", (Object)"1.0.0"));
        map.put("servers", Collections.singleton(ImmutableMap.of((Object)"url", (Object)"http://localhost:8080")));
        return map;
    }

    private List<String> getAllSpecFilesInDirectory() {
        Path rootDirectory = new File(this.inputSpecRootDirectory).toPath();
        try {
            return Files.walk(rootDirectory, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).map(path -> rootDirectory.relativize((Path)path).toString()).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Exception while listing files in spec root directory: " + this.inputSpecRootDirectory, e);
        }
    }

    private void deleteMergedFileFromPreviousRun() {
        try {
            Files.deleteIfExists(Paths.get(this.inputSpecRootDirectory + File.separator + this.mergeFileName + ".json", new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Files.deleteIfExists(Paths.get(this.inputSpecRootDirectory + File.separator + this.mergeFileName + ".yaml", new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class SpecWithPaths {
        private final String specRelatedPath;
        private final Set<String> paths;

        private SpecWithPaths(String specRelatedPath, Set<String> paths) {
            this.specRelatedPath = specRelatedPath;
            this.paths = paths;
        }
    }
}

