/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractPhpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;

public class PhpLaravelServerCodegen
extends AbstractPhpCodegen {
    protected String apiVersion = "1.0.0";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "php-laravel";
    }

    @Override
    public String getHelp() {
        return "Generates a PHP laravel server library.";
    }

    public PhpLaravelServerCodegen() {
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).wireFormatFeatures(EnumSet.of(WireFormatFeature.JSON, WireFormatFeature.XML)).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).excludeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}));
        this.templateDir = "php-laravel";
        this.embeddedTemplateDir = "php-laravel";
        this.variableNamingConvention = "camelCase";
        this.invokerPackage = "php-laravel";
        this.outputFolder = this.srcBasePath;
        this.apiPackage = "app.Http.Controllers";
        this.modelPackage = "app\\Models";
        this.apiTestTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.supportingFiles.add(new SupportingFile("composer.mustache", this.outputFolder, "composer.json"));
        this.supportingFiles.add(new SupportingFile("README.md", this.outputFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("artisan", this.outputFolder, "artisan"));
        this.supportingFiles.add(new SupportingFile("package.json", this.outputFolder, "package.json"));
        this.supportingFiles.add(new SupportingFile("phpunit.xml", this.outputFolder, "phpunit.xml"));
        this.supportingFiles.add(new SupportingFile("webpack.mix.js", this.outputFolder, "webpack.mix.js"));
        this.supportingFiles.add(new SupportingFile("editorconfig", this.outputFolder, ".editorconfig"));
        this.supportingFiles.add(new SupportingFile("env.example", this.outputFolder, ".env.example"));
        this.supportingFiles.add(new SupportingFile("gitattributes", this.outputFolder, ".gitattributes"));
        this.supportingFiles.add(new SupportingFile("styleci.yml", this.outputFolder, ".styleci.yml"));
        this.supportingFiles.add(new SupportingFile("server.php", this.outputFolder, "server.php"));
        this.supportingFiles.add(new SupportingFile("gitignore", this.outputFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("bootstrap/cache/gitignore", this.outputFolder + File.separator + "bootstrap" + File.separator + "cache", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("bootstrap/app.php", this.outputFolder + File.separator + "bootstrap", "app.php"));
        this.supportingFiles.add(new SupportingFile("public/.htaccess", this.outputFolder + File.separator + "public", ".htaccess"));
        this.supportingFiles.add(new SupportingFile("public/favicon.ico", this.outputFolder + File.separator + "public", "favicon.ico"));
        this.supportingFiles.add(new SupportingFile("public/index.php", this.outputFolder + File.separator + "public", "index.php"));
        this.supportingFiles.add(new SupportingFile("public/robots.txt", this.outputFolder + File.separator + "public", "robots.txt"));
        this.supportingFiles.add(new SupportingFile("public/web.config", this.outputFolder + File.separator + "public", "web.config"));
        this.supportingFiles.add(new SupportingFile("routes/api.mustache", this.outputFolder + File.separator + "routes", "api.php"));
        this.supportingFiles.add(new SupportingFile("routes/web.mustache", this.outputFolder + File.separator + "routes", "web.php"));
        this.supportingFiles.add(new SupportingFile("routes/channels.mustache", this.outputFolder + File.separator + "routes", "channels.php"));
        this.supportingFiles.add(new SupportingFile("routes/console.mustache", this.outputFolder + File.separator + "routes", "console.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Kernel.php", this.outputFolder + File.separator + "app" + File.separator + "Http", "Kernel.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Controllers/Controller.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers", "Controller.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/Authenticate.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "Authenticate.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/CheckForMaintenanceMode.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "CheckForMaintenanceMode.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/EncryptCookies.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "EncryptCookies.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/RedirectIfAuthenticated.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "RedirectIfAuthenticated.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/TrimStrings.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "TrimStrings.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/TrustProxies.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "TrustProxies.php"));
        this.supportingFiles.add(new SupportingFile("app/Http/Middleware/VerifyCsrfToken.php", this.outputFolder + File.separator + "app" + File.separator + "Http" + File.separator + "Middleware", "VerifyCsrfToken.php"));
        this.supportingFiles.add(new SupportingFile("app/Console/Kernel.php", this.outputFolder + File.separator + "app" + File.separator + "Console", "Kernel.php"));
        this.supportingFiles.add(new SupportingFile("app/Exceptions/Handler.php", this.outputFolder + File.separator + "app" + File.separator + "Exceptions", "Handler.php"));
        this.supportingFiles.add(new SupportingFile("app/Providers/AppServiceProvider.php", this.outputFolder + File.separator + "app" + File.separator + "Providers", "AppServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app/Providers/AuthServiceProvider.php", this.outputFolder + File.separator + "app" + File.separator + "Providers", "AuthServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app/Providers/BroadcastServiceProvider.php", this.outputFolder + File.separator + "app" + File.separator + "Providers", "BroadcastServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app/Providers/EventServiceProvider.php", this.outputFolder + File.separator + "app" + File.separator + "Providers", "EventServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app/Providers/RouteServiceProvider.php", this.outputFolder + File.separator + "app" + File.separator + "Providers", "RouteServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("app/User.php", this.outputFolder + File.separator + "app", "RouteServiceProvider.php"));
        this.supportingFiles.add(new SupportingFile("database/factories/UserFactory.php", this.outputFolder + File.separator + "database" + File.separator + "factories", "UserFactory.php"));
        this.supportingFiles.add(new SupportingFile("database/migrations/2014_10_12_000000_create_users_table.php", this.outputFolder + File.separator + "database" + File.separator + "migrations", "2014_10_12_000000_create_users_table.php"));
        this.supportingFiles.add(new SupportingFile("database/migrations/2019_08_19_000000_create_failed_jobs_table.php", this.outputFolder + File.separator + "database" + File.separator + "migrations", "2019_08_19_000000_create_failed_jobs_table.php"));
        this.supportingFiles.add(new SupportingFile("database/seeds/DatabaseSeeder.php", this.outputFolder + File.separator + "database" + File.separator + "seeds", "DatabaseSeeder.php"));
        this.supportingFiles.add(new SupportingFile("database/gitignore", this.outputFolder + File.separator + "database", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("config/app.php", this.outputFolder + File.separator + "config", "app.php"));
        this.supportingFiles.add(new SupportingFile("config/auth.php", this.outputFolder + File.separator + "config", "auth.php"));
        this.supportingFiles.add(new SupportingFile("config/broadcasting.php", this.outputFolder + File.separator + "config", "broadcasting.php"));
        this.supportingFiles.add(new SupportingFile("config/cache.php", this.outputFolder + File.separator + "config", "cache.php"));
        this.supportingFiles.add(new SupportingFile("config/cors.php", this.outputFolder + File.separator + "config", "cors.php"));
        this.supportingFiles.add(new SupportingFile("config/database.php", this.outputFolder + File.separator + "config", "database.php"));
        this.supportingFiles.add(new SupportingFile("config/filesystems.php", this.outputFolder + File.separator + "config", "filesystems.php"));
        this.supportingFiles.add(new SupportingFile("config/hashing.php", this.outputFolder + File.separator + "config", "hashing.php"));
        this.supportingFiles.add(new SupportingFile("config/logging.php", this.outputFolder + File.separator + "config", "logging.php"));
        this.supportingFiles.add(new SupportingFile("config/mail.php", this.outputFolder + File.separator + "config", "mail.php"));
        this.supportingFiles.add(new SupportingFile("config/queue.php", this.outputFolder + File.separator + "config", "queue.php"));
        this.supportingFiles.add(new SupportingFile("config/services.php", this.outputFolder + File.separator + "config", "services.php"));
        this.supportingFiles.add(new SupportingFile("config/session.php", this.outputFolder + File.separator + "config", "session.php"));
        this.supportingFiles.add(new SupportingFile("config/view.php", this.outputFolder + File.separator + "config", "view.php"));
        this.supportingFiles.add(new SupportingFile("database/migrations/2019_08_19_000000_create_failed_jobs_table.php", this.outputFolder + File.separator + "database" + File.separator + "migrations", "2019_08_19_000000_create_failed_jobs_table.php"));
        this.supportingFiles.add(new SupportingFile("resources/js/app.js", this.outputFolder + File.separator + "resources" + File.separator + "assets" + File.separator + "js", "app.js"));
        this.supportingFiles.add(new SupportingFile("resources/js/bootstrap.js", this.outputFolder + File.separator + "resources" + File.separator + "assets" + File.separator + "js", "bootstrap.js"));
        this.supportingFiles.add(new SupportingFile("resources/sass/app.scss", this.outputFolder + File.separator + "resources" + File.separator + "assets" + File.separator + "sass", "app.scss"));
        this.supportingFiles.add(new SupportingFile("resources/lang/en/auth.php", this.outputFolder + File.separator + "resources" + File.separator + "lang" + File.separator + "en", "auth.php"));
        this.supportingFiles.add(new SupportingFile("resources/lang/en/pagination.php", this.outputFolder + File.separator + "resources" + File.separator + "lang" + File.separator + "en", "pagination.php"));
        this.supportingFiles.add(new SupportingFile("resources/lang/en/passwords.php", this.outputFolder + File.separator + "resources" + File.separator + "lang" + File.separator + "en", "passwords.php"));
        this.supportingFiles.add(new SupportingFile("resources/lang/en/validation.php", this.outputFolder + File.separator + "resources" + File.separator + "lang" + File.separator + "en", "validation.php"));
        this.supportingFiles.add(new SupportingFile("resources/views/welcome.blade.php", this.outputFolder + File.separator + "resources" + File.separator + "views", "welcome.blade.php"));
        this.supportingFiles.add(new SupportingFile("storage/app/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "app", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/app/public/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "app" + File.separator + "public", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/cache/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework" + File.separator + "cache", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/cache/data/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework" + File.separator + "cache", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/sessions/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework" + File.separator + "sessions", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/testing/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework" + File.separator + "testing", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/framework/views/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "framework" + File.separator + "views", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("storage/logs/gitignore", this.outputFolder + File.separator + "storage" + File.separator + "logs", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("tests/Feature/ExampleTest.php", this.outputFolder + File.separator + "tests" + File.separator + "Feature", "ExampleTest.php"));
        this.supportingFiles.add(new SupportingFile("tests/Unit/ExampleTest.php", this.outputFolder + File.separator + "tests" + File.separator + "Unit", "ExampleTest.php"));
        this.supportingFiles.add(new SupportingFile("tests/CreatesApplication.php", this.outputFolder + File.separator + "tests", "CreatesApplication.php"));
        this.supportingFiles.add(new SupportingFile("tests/TestCase.php", this.outputFolder + File.separator + "tests", "TestCase.php"));
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.remove(this.supportingFiles.size() - 1);
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap objectMap = objs.getOperations();
        List<CodegenOperation> operations = objectMap.getOperation();
        for (CodegenOperation op : operations) {
            op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
            if (op.path != null && op.path.contains(".")) {
                throw new IllegalArgumentException("'.' (dot) is not supported by PHP laravel. Please refer to https://github.com/swagger-api/swagger-codegen/issues/6897 for more info.");
            }
            if (!op.hasProduces) continue;
            List<Map<String, String>> c = op.produces;
            for (Map<String, String> mediaType : c) {
                if (!"*/*".equals(mediaType.get("mediaType"))) continue;
                mediaType.put("mediaType", "*_/_*");
            }
        }
        operations.sort(Comparator.comparing(lhs -> lhs.path));
        return objs;
    }

    @Override
    public String toApiName(String name) {
        if (name.isEmpty()) {
            return "DefaultController";
        }
        return StringUtils.camelize(name, false) + "Controller";
    }

    protected String controllerFileFolder() {
        return this.outputFolder + File.separator + this.srcBasePath + File.separator + "app" + File.separator + "Http" + File.separator + "Controllers";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        if (templateName.equals("api.mustache")) {
            return this.controllerFileFolder() + '/' + this.toControllerName(tag) + suffix;
        }
        return this.apiFileFolder() + '/' + this.toApiFilename(tag) + suffix;
    }

    protected String toControllerName(String name) {
        if (name.isEmpty()) {
            return "DefaultController";
        }
        return StringUtils.camelize(name, false) + "Controller";
    }

    @Override
    protected String getEnumDefaultValue(String defaultValue, String dataType) {
        return defaultValue;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema p, boolean required) {
        CodegenProperty property = super.fromProperty(name, p, required);
        Schema referencedSchema = ModelUtils.getReferencedSchema(this.openAPI, p);
        if (!property.isEnum && referencedSchema.getEnum() != null && !referencedSchema.getEnum().isEmpty()) {
            property.dataType = this.getSchemaType(referencedSchema);
            property.defaultValue = this.toDefaultValue(referencedSchema);
            List _enum = referencedSchema.getEnum();
            HashMap<String, Object> allowableValues = new HashMap<String, Object>();
            allowableValues.put("values", _enum);
            if (allowableValues.size() > 0) {
                property.allowableValues = allowableValues;
            }
        }
        return property;
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
            if (!Boolean.TRUE.equals(p.getNullable())) {
                return "false";
            }
        } else if (!(ModelUtils.isDateSchema(p) || ModelUtils.isDateTimeSchema(p) || ModelUtils.isFileSchema(p))) {
            if (ModelUtils.isNumberSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                if (!Boolean.TRUE.equals(p.getNullable())) {
                    return "0";
                }
            } else if (ModelUtils.isIntegerSchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                if (!Boolean.TRUE.equals(p.getNullable())) {
                    return "0";
                }
            } else if (ModelUtils.isStringSchema(p)) {
                if (p.getDefault() != null) {
                    return "'" + p.getDefault() + "'";
                }
                if (!Boolean.TRUE.equals(p.getNullable())) {
                    return "\"\"";
                }
            } else if (ModelUtils.isArraySchema(p)) {
                if (p.getDefault() != null) {
                    return p.getDefault().toString();
                }
                if (!Boolean.TRUE.equals(p.getNullable())) {
                    return "[]";
                }
            }
        }
        return null;
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "::" + value;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return super.toEnumVarName(value, datatype);
        }
        if ("int".equals(datatype) || "float".equals(datatype)) {
            String varName = "NUMBER_" + value;
            varName = varName.replaceAll("-", "MINUS_");
            varName = varName.replaceAll("\\+", "PLUS_");
            varName = varName.replaceAll("\\.", "_DOT_");
            return varName;
        }
        return super.toEnumVarName(value, datatype);
    }
}

