/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.templating.mustache;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import java.io.IOException;
import java.io.Writer;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.utils.StringUtils;

public class CamelCaseLambda
implements Mustache.Lambda {
    private CodegenConfig generator = null;
    private Boolean escapeParam = false;
    private Boolean lowercaseFirstLetter = true;

    public CamelCaseLambda(boolean lowercaseFirstLetter) {
        this.lowercaseFirstLetter = lowercaseFirstLetter;
    }

    public CamelCaseLambda() {
    }

    public CamelCaseLambda generator(CodegenConfig generator) {
        this.generator = generator;
        return this;
    }

    public CamelCaseLambda escapeAsParamName(Boolean escape) {
        this.escapeParam = escape;
        return this;
    }

    public void execute(Template.Fragment fragment, Writer writer) throws IOException {
        String text = StringUtils.camelize(fragment.execute().replace(" ", "_"), this.lowercaseFirstLetter);
        if (this.generator != null) {
            text = this.generator.sanitizeName(text);
            if (this.generator.reservedWords().contains(text)) {
                text = this.generator.escapeReservedWord(text);
            }
            if (this.escapeParam.booleanValue()) {
                text = this.generator.toParamName(text);
            }
        }
        writer.write(text);
    }
}

