/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractCSharpCodegen;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SchemaSupportFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.openapitools.codegen.utils.URLPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSharpNancyFXServerCodegen
extends AbstractCSharpCodegen {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSharpNancyFXServerCodegen.class);
    private static final String API_NAMESPACE = "Modules";
    private static final String MODEL_NAMESPACE = "Models";
    private static final String IMMUTABLE_OPTION = "immutable";
    private static final String USE_BASE_PATH = "writeModulePath";
    private static final String PACKAGE_CONTEXT = "packageContext";
    private static final String ASYNC_SERVER = "asyncServer";
    private static final Map<String, Predicate<Schema>> propertyToOpenAPITypeMapping = CSharpNancyFXServerCodegen.createPropertyToOpenAPITypeMapping();
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase(Locale.ROOT) + "}";
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final Set<String> parentModels = new HashSet<String>();
    private final Multimap<String, CodegenModel> childrenByParent = ArrayListMultimap.create();
    private final BiMap<String, String> modelNameMapping = HashBiMap.create();
    private boolean asyncServer = false;

    public CSharpNancyFXServerCodegen() {
        this.modifyFeatureSet(features -> features.excludeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).securityFeatures(EnumSet.noneOf(SecurityFeature.class)).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects, GlobalFeature.ParameterStyling}).includeSchemaSupportFeatures(new SchemaSupportFeature[]{SchemaSupportFeature.Polymorphism}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.apiTemplateFiles.put("api.mustache", ".cs");
        this.setInterfacePrefix("");
        this.setReservedWordsLowerCase(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("interfacePrefix", "Prefix interfaces with a community standard or widely accepted prefix.", this.interfacePrefix);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption(PACKAGE_CONTEXT, "Optionally overrides the PackageContext which determines the namespace (namespace=packageName.packageContext). If not set, packageContext will default to basePath.", null);
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("optionalProjectFile", "Generate {PackageName}.csproj.", this.optionalProjectFileFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.addSwitch(IMMUTABLE_OPTION, "Enabled by default. If disabled generates model classes with setters", true);
        this.addSwitch(USE_BASE_PATH, "Enabled by default. If disabled, module paths will not mirror api base path", true);
        this.addSwitch(ASYNC_SERVER, "Set to true to enable the generation of async routes/endpoints.", this.asyncServer);
        this.typeMapping.putAll(CSharpNancyFXServerCodegen.nodaTimeTypesMappings());
        this.languageSpecificPrimitives.addAll(CSharpNancyFXServerCodegen.nodaTimePrimitiveTypes());
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "csharp-nancyfx";
    }

    @Override
    public String getHelp() {
        return "Generates a C# NancyFX Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.apiPackage = Strings.isNullOrEmpty((String)this.packageName) ? API_NAMESPACE : this.packageName + "." + API_NAMESPACE;
        this.modelPackage = Strings.isNullOrEmpty((String)this.packageName) ? MODEL_NAMESPACE : this.packageName + "." + MODEL_NAMESPACE;
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("parameters.mustache", this.sourceFile("Utils"), "Parameters.cs"));
        this.supportingFiles.add(new SupportingFile("localDateConverter.mustache", this.sourceFile("Utils"), "LocalDateConverter.cs"));
        this.supportingFiles.add(new SupportingFile("packages.config.mustache", this.sourceFolder(), "packages.config"));
        this.supportingFiles.add(new SupportingFile("nuspec.mustache", this.sourceFolder(), this.packageName + ".nuspec"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
            this.supportingFiles.add(new SupportingFile("Project.mustache", this.sourceFolder(), this.packageName + ".csproj"));
        }
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        if (this.additionalProperties.containsKey(ASYNC_SERVER)) {
            this.setAsyncServer(this.convertPropertyToBooleanAndWriteBack(ASYNC_SERVER));
        } else {
            this.additionalProperties.put(ASYNC_SERVER, this.asyncServer);
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.setupModelTemplate();
        this.processImportedMappings();
        this.appendDependencies();
    }

    private void setupModelTemplate() {
        Object immutableOption = this.additionalProperties.get(IMMUTABLE_OPTION);
        if (immutableOption != null && "false".equalsIgnoreCase(immutableOption.toString())) {
            LOGGER.info("Using mutable model template");
            this.modelTemplateFiles.put("modelMutable.mustache", ".cs");
        } else {
            LOGGER.info("Using immutable model template");
            this.modelTemplateFiles.put("model.mustache", ".cs");
        }
    }

    private void processImportedMappings() {
        for (Map.Entry entry : ImmutableSet.copyOf(this.importMapping.entrySet())) {
            String assemblyFramework;
            String model = (String)entry.getKey();
            String[] namespaceInfo = ((String)entry.getValue()).split("\\s");
            String[] namespace = (namespaceInfo.length > 0 ? namespaceInfo[0].trim() : "").split(":");
            String namespaceName = namespace.length > 0 ? namespace[0].trim() : null;
            String modelClass = namespace.length > 1 ? namespace[1].trim() : null;
            String assembly = namespaceInfo.length > 1 ? namespaceInfo[1].trim() : null;
            String assemblyVersion = namespaceInfo.length > 2 ? namespaceInfo[2].trim() : null;
            String string = assemblyFramework = namespaceInfo.length > 3 ? namespaceInfo[3].trim() : "net45";
            if (Strings.isNullOrEmpty((String)model) || Strings.isNullOrEmpty((String)namespaceName)) {
                LOGGER.warn(String.format(Locale.ROOT, "Could not import: '%s' - invalid namespace: '%s'", model, entry.getValue()));
                this.importMapping.remove(model);
            } else {
                LOGGER.info(String.format(Locale.ROOT, "Importing: '%s' from '%s' namespace.", model, namespaceName));
                this.importMapping.put(model, namespaceName);
            }
            if (!Strings.isNullOrEmpty((String)modelClass)) {
                LOGGER.info(String.format(Locale.ROOT, "Mapping: '%s' class to '%s'", model, modelClass));
                this.modelNameMapping.put((Object)model, (Object)modelClass);
            }
            if (assembly == null || assemblyVersion == null) continue;
            LOGGER.info(String.format(Locale.ROOT, "Adding dependency: '%s', version: '%s', framework: '%s'", assembly, assemblyVersion, assemblyVersion));
            this.dependencies.put(assembly, new DependencyInfo(assemblyVersion, assemblyFramework));
        }
    }

    private void appendDependencies() {
        ArrayList listOfDependencies = new ArrayList();
        for (Map.Entry<String, DependencyInfo> dependency : this.dependencies.entrySet()) {
            HashMap<String, String> dependencyInfo = new HashMap<String, String>();
            dependencyInfo.put("dependency", dependency.getKey());
            dependencyInfo.put("dependencyVersion", dependency.getValue().version);
            dependencyInfo.put("dependencyFramework", dependency.getValue().framework);
            listOfDependencies.add(dependencyInfo);
        }
        this.additionalProperties.put("dependencies", listOfDependencies);
    }

    private String sourceFolder() {
        return "src" + File.separator + this.packageName;
    }

    private String sourceFile(String fileName) {
        return this.sourceFolder() + File.separator + fileName;
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    public void setAsyncServer(boolean asyncServer) {
        this.asyncServer = asyncServer;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + API_NAMESPACE;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder() + File.separator + MODEL_NAMESPACE;
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (!Strings.isNullOrEmpty((String)operation.path) && operation.path.contains("?")) {
            operation.path = operation.path.replace("?", "/");
        }
        if (!Strings.isNullOrEmpty((String)operation.httpMethod)) {
            operation.httpMethod = org.apache.commons.lang3.StringUtils.capitalize((String)operation.httpMethod.toLowerCase(Locale.ROOT));
        }
    }

    @Override
    public Map<String, Object> postProcessAllModels(Map<String, Object> models) {
        Map<String, Object> processed = super.postProcessAllModels(models);
        this.postProcessParentModels(models);
        return processed;
    }

    private void postProcessParentModels(Map<String, Object> models) {
        LOGGER.debug("Processing parents:  " + this.parentModels);
        for (String parent : this.parentModels) {
            CodegenModel parentModel = ModelUtils.getModelByName(parent, models);
            if (parentModel == null) continue;
            parentModel.hasChildren = true;
            Collection childrenModels = this.childrenByParent.get((Object)parent);
            for (CodegenModel child : childrenModels) {
                this.processParentPropertiesInChildModel(parentModel, child);
            }
        }
    }

    private void processParentPropertiesInChildModel(CodegenModel parent, CodegenModel child) {
        HashMap<String, CodegenProperty> childPropertiesByName = new HashMap<String, CodegenProperty>(child.vars.size());
        for (CodegenProperty property : child.vars) {
            childPropertiesByName.put(property.name, property);
        }
        CodegenProperty previousParentVar = null;
        for (CodegenProperty property : parent.vars) {
            CodegenProperty duplicatedByParent = (CodegenProperty)childPropertiesByName.get(property.name);
            if (duplicatedByParent == null) continue;
            LOGGER.info(String.format(Locale.ROOT, "Property: '%s' in '%s' model is inherited from '%s'", property.name, child.classname, parent.classname));
            duplicatedByParent.isInherited = true;
            CodegenProperty parentVar = duplicatedByParent.clone();
            child.parentVars.add(parentVar);
            previousParentVar = parentVar;
        }
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        if (!Strings.isNullOrEmpty((String)model.parent)) {
            this.parentModels.add(model.parent);
            if (!this.childrenByParent.containsEntry((Object)model.parent, (Object)model)) {
                this.childrenByParent.put((Object)model.parent, (Object)model);
            }
        }
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        if (name.length() == 0) {
            return "Empty";
        }
        String enumName = StringUtils.camelize(this.sanitizeName(name).replaceFirst("^_", "").replaceFirst("_$", "").replaceAll("-", "_"));
        String result = enumName.matches("\\d.*") ? "_" + enumName : enumName;
        LOGGER.debug(String.format(Locale.ROOT, "toEnumVarName('%s', %s) = '%s'", name, datatype, enumName));
        return result;
    }

    @Override
    public String toApiName(String name) {
        String apiName = Strings.isNullOrEmpty((String)name) ? "Default" : org.apache.commons.lang3.StringUtils.capitalize((String)name);
        LOGGER.debug(String.format(Locale.ROOT, "toApiName('%s') = '%s'", name, apiName));
        return apiName;
    }

    @Override
    public String toApiFilename(String name) {
        return super.toApiFilename(name) + "Module";
    }

    @Override
    public String toModelImport(String name) {
        String modelName;
        String result = this.modelNameMapping.containsValue((Object)name) ? (this.importMapping.containsKey(modelName = (String)this.modelNameMapping.inverse().get((Object)name)) ? (String)this.importMapping.get(modelName) : super.toModelImport(name)) : (this.importMapping.containsKey(name) ? (String)this.importMapping.get(name) : null);
        LOGGER.debug(String.format(Locale.ROOT, "toModelImport('%s') = '%s'", name, result));
        return result;
    }

    @Override
    public String toModelName(String name) {
        String modelName = super.toModelName(name);
        String mappedModelName = (String)this.modelNameMapping.get((Object)modelName);
        return Strings.isNullOrEmpty((String)mappedModelName) ? modelName : mappedModelName;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        URL url = URLPathUtils.getServerURL(openAPI, this.serverVariableOverrides());
        String path = URLPathUtils.getPath(url, "/");
        String packageContextOption = (String)this.additionalProperties.get(PACKAGE_CONTEXT);
        this.additionalProperties.put(PACKAGE_CONTEXT, packageContextOption == null ? this.sanitizeName(path) : packageContextOption);
        Object basePathOption = this.additionalProperties.get(USE_BASE_PATH);
        this.additionalProperties.put("baseContext", basePathOption == null ? path : "/");
    }

    @Override
    public String toEnumName(CodegenProperty property) {
        return this.sanitizeName(StringUtils.camelize(property.name)) + "Enum";
    }

    @Override
    public String getSchemaType(Schema property) {
        for (Map.Entry<String, Predicate<Schema>> entry : propertyToOpenAPITypeMapping.entrySet()) {
            if (!entry.getValue().apply((Object)property)) continue;
            return entry.getKey();
        }
        return super.getSchemaType(property);
    }

    private static Map<String, Predicate<Schema>> createPropertyToOpenAPITypeMapping() {
        ImmutableMap.Builder mapping = ImmutableMap.builder();
        mapping.put((Object)"time", CSharpNancyFXServerCodegen.timeProperty());
        return mapping.build();
    }

    private static Predicate<Schema> timeProperty() {
        return new Predicate<Schema>(){

            public boolean apply(Schema property) {
                return ModelUtils.isStringSchema(property) && "time".equalsIgnoreCase(property.getFormat());
            }
        };
    }

    private static Map<String, String> nodaTimeTypesMappings() {
        return ImmutableMap.of((Object)"time", (Object)"LocalTime?", (Object)"date", (Object)"LocalDate?", (Object)"datetime", (Object)"ZonedDateTime?");
    }

    private static Set<String> nodaTimePrimitiveTypes() {
        return ImmutableSet.of((Object)"LocalTime?", (Object)"LocalDate?", (Object)"ZonedDateTime?");
    }

    private class DependencyInfo {
        private final String version;
        private final String framework;

        private DependencyInfo(String version, String framework) {
            this.version = version;
            this.framework = framework;
        }
    }
}

