/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.plugin;

import com.fasterxml.jackson.databind.Module;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import com.google.common.io.FileWriteMode;
import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.util.ClasspathHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.ClientOptInput;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultGenerator;
import org.openapitools.codegen.auth.AuthParser;
import org.openapitools.codegen.config.CodegenConfigurator;
import org.openapitools.codegen.config.CodegenConfiguratorUtils;
import org.openapitools.codegen.config.GlobalSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.sonatype.plexus.build.incremental.DefaultBuildContext;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class CodeGenMojo
extends AbstractMojo {
    private final Logger LOGGER = LoggerFactory.getLogger(CodeGenMojo.class);
    @Component
    private BuildContext buildContext = new DefaultBuildContext();
    @Parameter(name="verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(name="generatorName", property="openapi.generator.maven.plugin.generatorName")
    private String generatorName;
    @Parameter(name="output", property="openapi.generator.maven.plugin.output")
    private File output;
    @Parameter(name="inputSpec", property="openapi.generator.maven.plugin.inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="gitHost", property="openapi.generator.maven.plugin.gitHost")
    private String gitHost;
    @Parameter(name="gitUserId", property="openapi.generator.maven.plugin.gitUserId")
    private String gitUserId;
    @Parameter(name="gitRepoId", property="openapi.generator.maven.plugin.gitRepoId")
    private String gitRepoId;
    @Parameter(name="templateDirectory", property="openapi.generator.maven.plugin.templateDirectory")
    private File templateDirectory;
    @Parameter(name="templateResourcePath", property="openapi.generator.maven.plugin.templateResourcePath")
    private String templateResourcePath;
    @Parameter(name="engine", defaultValue="mustache", property="openapi.generator.maven.plugin.engine")
    private String engine;
    @Parameter(name="auth", property="openapi.generator.maven.plugin.auth")
    private String auth;
    @Parameter(name="configurationFile", property="openapi.generator.maven.plugin.configurationFile")
    private String configurationFile;
    @Parameter(name="skipOverwrite", property="openapi.generator.maven.plugin.skipOverwrite")
    private Boolean skipOverwrite;
    @Parameter(name="apiPackage", property="openapi.generator.maven.plugin.apiPackage")
    private String apiPackage;
    @Parameter(name="modelPackage", property="openapi.generator.maven.plugin.modelPackage")
    private String modelPackage;
    @Parameter(name="invokerPackage", property="openapi.generator.maven.plugin.invokerPackage")
    private String invokerPackage;
    @Parameter(name="packageName", property="openapi.generator.maven.plugin.packageName")
    private String packageName;
    @Parameter(name="groupId", property="openapi.generator.maven.plugin.groupId")
    private String groupId;
    @Parameter(name="artifactId", property="openapi.generator.maven.plugin.artifactId")
    private String artifactId;
    @Parameter(name="artifactVersion", property="openapi.generator.maven.plugin.artifactVersion")
    private String artifactVersion;
    @Parameter(name="library", property="openapi.generator.maven.plugin.library")
    private String library;
    @Parameter(name="modelNamePrefix", property="openapi.generator.maven.plugin.modelNamePrefix")
    private String modelNamePrefix;
    @Parameter(name="modelNameSuffix", property="openapi.generator.maven.plugin.modelNameSuffix")
    private String modelNameSuffix;
    @Parameter(name="apiNameSuffix", property="openapi.generator.maven.plugin.apiNameSuffix")
    private String apiNameSuffix;
    @Parameter(name="ignoreFileOverride", property="openapi.generator.maven.plugin.ignoreFileOverride")
    private String ignoreFileOverride;
    @Parameter(name="httpUserAgent", property="openapi.generator.maven.plugin.httpUserAgent")
    private String httpUserAgent;
    @Parameter(name="removeOperationIdPrefix", property="openapi.generator.maven.plugin.removeOperationIdPrefix")
    private Boolean removeOperationIdPrefix;
    @Parameter(name="skipOperationExample", property="openapi.generator.maven.plugin.skipOperationExample")
    private Boolean skipOperationExample;
    @Parameter(name="logToStderr", property="openapi.generator.maven.plugin.logToStderr")
    private Boolean logToStderr;
    @Parameter(name="enablePostProcessFile", property="openapi.generator.maven.plugin.enablePostProcessFile")
    private Boolean enablePostProcessFile;
    @Parameter(name="skipValidateSpec", property="openapi.generator.maven.plugin.skipValidateSpec")
    private Boolean skipValidateSpec;
    @Parameter(name="strictSpec", property="openapi.generator.maven.plugin.strictSpec")
    private Boolean strictSpec;
    @Parameter(name="generateAliasAsModel", property="openapi.generator.maven.plugin.generateAliasAsModel")
    private Boolean generateAliasAsModel;
    @Parameter(name="configOptions")
    private Map<?, ?> configOptions;
    @Parameter(name="instantiationTypes", property="openapi.generator.maven.plugin.instantiationTypes")
    private List<String> instantiationTypes;
    @Parameter(name="importMappings", property="openapi.generator.maven.plugin.importMappings")
    private List<String> importMappings;
    @Parameter(name="schemaMappings", property="openapi.generator.maven.plugin.schemaMappings")
    private List<String> schemaMappings;
    @Parameter(name="inlineSchemaNameMappings", property="openapi.generator.maven.plugin.inlineSchemaNameMappings")
    private List<String> inlineSchemaNameMappings;
    @Parameter(name="inlineSchemaNameDefaults", property="openapi.generator.maven.plugin.inlineSchemaNameDefaults")
    private List<String> inlineSchemaNameDefaults;
    @Parameter(name="typeMappings", property="openapi.generator.maven.plugin.typeMappings")
    private List<String> typeMappings;
    @Parameter(name="languageSpecificPrimitives", property="openapi.generator.maven.plugin.languageSpecificPrimitives")
    private List<String> languageSpecificPrimitives;
    @Parameter(name="additionalProperties", property="openapi.generator.maven.plugin.additionalProperties")
    private List<String> additionalProperties;
    @Parameter(name="serverVariableOverrides", property="openapi.generator.maven.plugin.serverVariableOverrides")
    private List<String> serverVariableOverrides;
    @Parameter(name="reservedWordsMappings", property="openapi.generator.maven.plugin.reservedWordsMappings")
    private List<String> reservedWordsMappings;
    @Parameter(name="generateApis", property="openapi.generator.maven.plugin.generateApis")
    private Boolean generateApis = true;
    @Parameter(name="apisToGenerate", property="openapi.generator.maven.plugin.apisToGenerate")
    private String apisToGenerate = "";
    @Parameter(name="generateModels", property="openapi.generator.maven.plugin.generateModels")
    private Boolean generateModels = true;
    @Parameter(name="modelsToGenerate", property="openapi.generator.maven.plugin.modelsToGenerate")
    private String modelsToGenerate = "";
    @Parameter(name="generateSupportingFiles", property="openapi.generator.maven.plugin.generateSupportingFiles")
    private Boolean generateSupportingFiles = true;
    @Parameter(name="supportingFilesToGenerate", property="openapi.generator.maven.plugin.supportingFilesToGenerate")
    private String supportingFilesToGenerate = "";
    @Parameter(name="generateModelTests", property="openapi.generator.maven.plugin.generateModelTests")
    private Boolean generateModelTests = true;
    @Parameter(name="generateModelDocumentation", property="openapi.generator.maven.plugin.generateModelDocumentation")
    private Boolean generateModelDocumentation = true;
    @Parameter(name="generateApiTests", property="openapi.generator.maven.plugin.generateApiTests")
    private Boolean generateApiTests = true;
    @Parameter(name="generateApiDocumentation", property="openapi.generator.maven.plugin.generateApiDocumentation")
    private Boolean generateApiDocumentation = true;
    @Parameter(name="withXml", property="openapi.generator.maven.plugin.withXml")
    private Boolean withXml = false;
    @Parameter(name="skip", property="codegen.skip", defaultValue="false")
    private Boolean skip;
    @Parameter(name="skipIfSpecIsUnchanged", property="codegen.skipIfSpecIsUnchanged", defaultValue="false")
    private Boolean skipIfSpecIsUnchanged;
    @Parameter(defaultValue="true", property="openapi.generator.maven.plugin.addCompileSourceRoot")
    private boolean addCompileSourceRoot = true;
    @Parameter(defaultValue="false", property="openapi.generator.maven.plugin.addTestCompileSourceRoot")
    private boolean addTestCompileSourceRoot = false;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter
    protected Map<String, String> globalProperties = new HashMap<String, String>();
    @Parameter(property="codegen.configHelp")
    private boolean configHelp = false;
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    private MojoExecution mojo;
    @Parameter(readonly=true, required=true, defaultValue="${project}")
    private MavenProject project;

    public void setBuildContext(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void execute() throws MojoExecutionException {
        File inputSpecFile = new File(this.inputSpec);
        if (this.output == null) {
            this.output = new File(this.project.getBuild().getDirectory(), LifecyclePhase.GENERATE_TEST_SOURCES.id().equals(this.mojo.getLifecyclePhase()) ? "generated-test-sources/openapi" : "generated-sources/openapi");
        }
        this.addCompileSourceRootIfConfigured();
        try {
            File parent;
            CodegenConfigurator configurator;
            File storedInputSpecHashFile;
            if (Boolean.TRUE.equals(this.skip)) {
                this.getLog().info((CharSequence)"Code generation is skipped.");
                return;
            }
            if (this.buildContext != null && this.inputSpec != null && this.buildContext.isIncremental() && inputSpecFile.exists() && !this.buildContext.hasDelta(inputSpecFile)) {
                this.getLog().info((CharSequence)"Code generation is skipped in delta-build because source-json was not modified.");
                return;
            }
            if (Boolean.TRUE.equals(this.skipIfSpecIsUnchanged) && (storedInputSpecHashFile = this.getHashFile(inputSpecFile)).exists()) {
                Object inputSpecHash = null;
                try {
                    inputSpecHash = this.calculateInputSpecHash(inputSpecFile);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                String string = com.google.common.io.Files.asCharSource((File)storedInputSpecHashFile, (Charset)StandardCharsets.UTF_8).read();
                if (string.equals(inputSpecHash)) {
                    this.getLog().info((CharSequence)"Code generation is skipped because input was unchanged");
                    return;
                }
            }
            if ((configurator = CodegenConfigurator.fromFile((String)this.configurationFile, (Module[])new Module[0])) == null) {
                configurator = new CodegenConfigurator();
            }
            configurator.setVerbose(this.verbose);
            if (this.skipOverwrite != null) {
                configurator.setSkipOverwrite(this.skipOverwrite.booleanValue());
            }
            if (this.removeOperationIdPrefix != null) {
                configurator.setRemoveOperationIdPrefix(this.removeOperationIdPrefix.booleanValue());
            }
            if (this.skipOperationExample != null) {
                configurator.setSkipOperationExample(this.skipOperationExample.booleanValue());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.inputSpec)) {
                configurator.setInputSpec(this.inputSpec);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitHost)) {
                configurator.setGitHost(this.gitHost);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitUserId)) {
                configurator.setGitUserId(this.gitUserId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.gitRepoId)) {
                configurator.setGitRepoId(this.gitRepoId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.ignoreFileOverride)) {
                configurator.setIgnoreFileOverride(this.ignoreFileOverride);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.httpUserAgent)) {
                configurator.setHttpUserAgent(this.httpUserAgent);
            }
            if (this.skipValidateSpec != null) {
                configurator.setValidateSpec(this.skipValidateSpec == false);
            }
            if (this.strictSpec != null) {
                configurator.setStrictSpecBehavior(this.strictSpec.booleanValue());
            }
            if (this.logToStderr != null) {
                configurator.setLogToStderr(this.logToStderr.booleanValue());
            }
            if (this.enablePostProcessFile != null) {
                configurator.setEnablePostProcessFile(this.enablePostProcessFile.booleanValue());
            }
            if (this.generateAliasAsModel != null) {
                configurator.setGenerateAliasAsModel(this.generateAliasAsModel.booleanValue());
            }
            if (!StringUtils.isNotEmpty((CharSequence)this.generatorName)) {
                this.LOGGER.error("A generator name (generatorName) is required.");
                throw new MojoExecutionException("The generator requires 'generatorName'. Refer to documentation for a list of options.");
            }
            configurator.setGeneratorName(this.generatorName);
            configurator.setOutputDir(this.output.getAbsolutePath());
            if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
                configurator.setAuth(this.auth);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.apiPackage)) {
                configurator.setApiPackage(this.apiPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelPackage)) {
                configurator.setModelPackage(this.modelPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.invokerPackage)) {
                configurator.setInvokerPackage(this.invokerPackage);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.packageName)) {
                configurator.setPackageName(this.packageName);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.groupId)) {
                configurator.setGroupId(this.groupId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactId)) {
                configurator.setArtifactId(this.artifactId);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.artifactVersion)) {
                configurator.setArtifactVersion(this.artifactVersion);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.library)) {
                configurator.setLibrary(this.library);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNamePrefix)) {
                configurator.setModelNamePrefix(this.modelNamePrefix);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.modelNameSuffix)) {
                configurator.setModelNameSuffix(this.modelNameSuffix);
            }
            if (StringUtils.isNotEmpty((CharSequence)this.apiNameSuffix)) {
                configurator.setApiNameSuffix(this.apiNameSuffix);
            }
            if (null != this.templateDirectory) {
                configurator.setTemplateDir(this.templateDirectory.getAbsolutePath());
            }
            if (StringUtils.isNotEmpty((CharSequence)this.templateResourcePath)) {
                if (null != this.templateDirectory) {
                    this.LOGGER.warn("Both templateDirectory and templateResourcePath were configured. templateResourcePath overwrites templateDirectory.");
                }
                configurator.setTemplateDir(this.templateResourcePath);
            }
            if (null != this.engine) {
                configurator.setTemplatingEngineName(this.engine);
            }
            if (null != this.generateApis && this.generateApis.booleanValue()) {
                GlobalSettings.setProperty((String)"apis", (String)this.apisToGenerate);
            } else {
                GlobalSettings.clearProperty((String)"apis");
            }
            if (null != this.generateModels && this.generateModels.booleanValue()) {
                GlobalSettings.setProperty((String)"models", (String)this.modelsToGenerate);
            } else {
                GlobalSettings.clearProperty((String)"models");
            }
            if (null != this.generateSupportingFiles && this.generateSupportingFiles.booleanValue()) {
                GlobalSettings.setProperty((String)"supportingFiles", (String)this.supportingFilesToGenerate);
            } else {
                GlobalSettings.clearProperty((String)"supportingFiles");
            }
            GlobalSettings.setProperty((String)"modelTests", (String)this.generateModelTests.toString());
            GlobalSettings.setProperty((String)"modelDocs", (String)this.generateModelDocumentation.toString());
            GlobalSettings.setProperty((String)"apiTests", (String)this.generateApiTests.toString());
            GlobalSettings.setProperty((String)"apiDocs", (String)this.generateApiDocumentation.toString());
            GlobalSettings.setProperty((String)"withXml", (String)this.withXml.toString());
            if (this.configOptions != null) {
                if (this.instantiationTypes == null && this.configOptions.containsKey("instantiation-types")) {
                    CodegenConfiguratorUtils.applyInstantiationTypesKvp((String)this.configOptions.get("instantiation-types").toString(), (CodegenConfigurator)configurator);
                }
                if (this.importMappings == null && this.configOptions.containsKey("import-mappings")) {
                    CodegenConfiguratorUtils.applyImportMappingsKvp((String)this.configOptions.get("import-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.schemaMappings == null && this.configOptions.containsKey("schema-mappings")) {
                    CodegenConfiguratorUtils.applySchemaMappingsKvp((String)this.configOptions.get("schema-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.inlineSchemaNameMappings == null && this.configOptions.containsKey("inline-schema-name-mappings")) {
                    CodegenConfiguratorUtils.applyInlineSchemaNameMappingsKvp((String)this.configOptions.get("inline-schema-name-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.inlineSchemaNameDefaults == null && this.configOptions.containsKey("inline-schema-name-defaults")) {
                    CodegenConfiguratorUtils.applyInlineSchemaNameDefaultsKvp((String)this.configOptions.get("inline-schema-name-defaults").toString(), (CodegenConfigurator)configurator);
                }
                if (this.typeMappings == null && this.configOptions.containsKey("type-mappings")) {
                    CodegenConfiguratorUtils.applyTypeMappingsKvp((String)this.configOptions.get("type-mappings").toString(), (CodegenConfigurator)configurator);
                }
                if (this.languageSpecificPrimitives == null && this.configOptions.containsKey("language-specific-primitives")) {
                    CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsv((String)this.configOptions.get("language-specific-primitives").toString(), (CodegenConfigurator)configurator);
                }
                if (this.additionalProperties == null && this.configOptions.containsKey("additional-properties")) {
                    CodegenConfiguratorUtils.applyAdditionalPropertiesKvp((String)this.configOptions.get("additional-properties").toString(), (CodegenConfigurator)configurator);
                }
                if (this.serverVariableOverrides == null && this.configOptions.containsKey("server-variables")) {
                    CodegenConfiguratorUtils.applyServerVariablesKvp((String)this.configOptions.get("server-variables").toString(), (CodegenConfigurator)configurator);
                }
                if (this.reservedWordsMappings == null && this.configOptions.containsKey("reserved-words-mappings")) {
                    CodegenConfiguratorUtils.applyReservedWordsMappingsKvp((String)this.configOptions.get("reserved-words-mappings").toString(), (CodegenConfigurator)configurator);
                }
            }
            if (!(this.instantiationTypes == null || this.configOptions != null && this.configOptions.containsKey("instantiation-types"))) {
                CodegenConfiguratorUtils.applyInstantiationTypesKvpList(this.instantiationTypes, (CodegenConfigurator)configurator);
            }
            if (!(this.importMappings == null || this.configOptions != null && this.configOptions.containsKey("import-mappings"))) {
                CodegenConfiguratorUtils.applyImportMappingsKvpList(this.importMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.schemaMappings == null || this.configOptions != null && this.configOptions.containsKey("schema-mappings"))) {
                CodegenConfiguratorUtils.applySchemaMappingsKvpList(this.schemaMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.inlineSchemaNameMappings == null || this.configOptions != null && this.configOptions.containsKey("inline-schema-name-mappings"))) {
                CodegenConfiguratorUtils.applyInlineSchemaNameMappingsKvpList(this.inlineSchemaNameMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.inlineSchemaNameDefaults == null || this.configOptions != null && this.configOptions.containsKey("inline-schema-name-defaults"))) {
                CodegenConfiguratorUtils.applyInlineSchemaNameDefaultsKvpList(this.inlineSchemaNameDefaults, (CodegenConfigurator)configurator);
            }
            if (!(this.typeMappings == null || this.configOptions != null && this.configOptions.containsKey("type-mappings"))) {
                CodegenConfiguratorUtils.applyTypeMappingsKvpList(this.typeMappings, (CodegenConfigurator)configurator);
            }
            if (!(this.languageSpecificPrimitives == null || this.configOptions != null && this.configOptions.containsKey("language-specific-primitives"))) {
                CodegenConfiguratorUtils.applyLanguageSpecificPrimitivesCsvList(this.languageSpecificPrimitives, (CodegenConfigurator)configurator);
            }
            if (!(this.additionalProperties == null || this.configOptions != null && this.configOptions.containsKey("additional-properties"))) {
                CodegenConfiguratorUtils.applyAdditionalPropertiesKvpList(this.additionalProperties, (CodegenConfigurator)configurator);
            }
            if (!(this.serverVariableOverrides == null || this.configOptions != null && this.configOptions.containsKey("server-variables"))) {
                CodegenConfiguratorUtils.applyServerVariablesKvpList(this.serverVariableOverrides, (CodegenConfigurator)configurator);
            }
            if (!(this.reservedWordsMappings == null || this.configOptions != null && this.configOptions.containsKey("reserved-words-mappings"))) {
                CodegenConfiguratorUtils.applyReservedWordsMappingsKvpList(this.reservedWordsMappings, (CodegenConfigurator)configurator);
            }
            if (this.globalProperties == null) {
                this.globalProperties = new HashMap<String, String>();
            }
            if (this.environmentVariables != null && this.environmentVariables.size() > 0) {
                this.globalProperties.putAll(this.environmentVariables);
                this.getLog().warn((CharSequence)"environmentVariables is deprecated and will be removed in version 5.1. Use globalProperties instead.");
            }
            for (Map.Entry entry : this.globalProperties.entrySet()) {
                Iterator key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null) continue;
                configurator.addGlobalProperty(key, value);
            }
            ClientOptInput input = configurator.toClientOptInput();
            CodegenConfig codegenConfig = input.getConfig();
            if (this.configOptions != null) {
                for (CliOption langCliOption : codegenConfig.cliOptions()) {
                    if (!this.configOptions.containsKey(langCliOption.getOpt())) continue;
                    input.getConfig().additionalProperties().put(langCliOption.getOpt(), this.configOptions.get(langCliOption.getOpt()));
                }
            }
            if (this.configHelp) {
                for (CliOption langCliOption : codegenConfig.cliOptions()) {
                    System.out.println("\t" + langCliOption.getOpt());
                    System.out.println("\t    " + langCliOption.getOptionHelp().replaceAll("\n", "\n\t    "));
                    System.out.println();
                }
                return;
            }
            this.adjustAdditionalProperties(codegenConfig);
            new DefaultGenerator().opts(input).generate();
            if (this.buildContext != null) {
                this.buildContext.refresh(new File(this.getCompileSourceRoot()));
            }
            File storedInputSpecHashFile2 = this.getHashFile(inputSpecFile);
            String inputSpecHash = this.calculateInputSpecHash(inputSpecFile);
            if (storedInputSpecHashFile2.getParent() != null && !new File(storedInputSpecHashFile2.getParent()).exists() && !(parent = new File(storedInputSpecHashFile2.getParent())).mkdirs()) {
                throw new RuntimeException("Failed to create the folder " + parent.getAbsolutePath() + " to store the checksum of the input spec.");
            }
            com.google.common.io.Files.asCharSink((File)storedInputSpecHashFile2, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)inputSpecHash);
        }
        catch (Exception e) {
            if (this.buildContext != null) {
                this.buildContext.addMessage(inputSpecFile, 0, 0, "unexpected error in Open-API generation", 1, (Throwable)e);
            }
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Code generation failed. See above for the full exception.");
        }
    }

    private String calculateInputSpecHash(File inputSpecFile) throws IOException {
        URL inputSpecRemoteUrl = this.inputSpecRemoteUrl();
        File inputSpecTempFile = inputSpecFile;
        if (inputSpecRemoteUrl != null) {
            inputSpecTempFile = Files.createTempFile("openapi-spec", ".tmp", new FileAttribute[0]).toFile();
            URLConnection conn = inputSpecRemoteUrl.openConnection();
            if (StringUtils.isNotEmpty((CharSequence)this.auth)) {
                List authList = AuthParser.parse((String)this.auth);
                for (AuthorizationValue a : authList) {
                    conn.setRequestProperty(a.getKeyName(), a.getValue());
                }
            }
            ReadableByteChannel readableByteChannel = Channels.newChannel(conn.getInputStream());
            Object object = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(inputSpecTempFile);){
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.transferFrom(readableByteChannel, 0L, Long.MAX_VALUE);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (readableByteChannel != null) {
                    if (object != null) {
                        try {
                            readableByteChannel.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        readableByteChannel.close();
                    }
                }
            }
        }
        ByteSource inputSpecByteSource = inputSpecTempFile.exists() ? com.google.common.io.Files.asByteSource((File)inputSpecTempFile) : CharSource.wrap((CharSequence)ClasspathHelper.loadFileFromClasspath((String)inputSpecTempFile.toString().replaceAll("\\\\", "/"))).asByteSource(StandardCharsets.UTF_8);
        return inputSpecByteSource.hash(Hashing.sha256()).toString();
    }

    private URL inputSpecRemoteUrl() {
        try {
            return new URI(this.inputSpec).toURL();
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            return null;
        }
    }

    private File getHashFile(File inputSpecFile) {
        String name = inputSpecFile.getName();
        URL url = this.inputSpecRemoteUrl();
        if (url != null) {
            String[] segments = url.getPath().split("/");
            name = com.google.common.io.Files.getNameWithoutExtension((String)segments[segments.length - 1]);
        }
        return new File(this.output.getPath() + File.separatorChar + ".openapi-generator" + File.separatorChar + name + "-" + this.mojo.getExecutionId() + ".sha256");
    }

    private String getCompileSourceRoot() {
        Object sourceFolderObject = this.configOptions == null ? null : (Object)this.configOptions.get("sourceFolder");
        String sourceFolder = sourceFolderObject != null ? sourceFolderObject.toString() : "src/main/java";
        return this.output.getPath() + File.separatorChar + sourceFolder;
    }

    private void addCompileSourceRootIfConfigured() throws MojoExecutionException {
        if (this.addCompileSourceRoot) {
            if (this.addTestCompileSourceRoot) {
                throw new MojoExecutionException("Either 'addCompileSourceRoot' or 'addTestCompileSourceRoot' may be active, not both.");
            }
            this.project.addCompileSourceRoot(this.getCompileSourceRoot());
        } else if (this.addTestCompileSourceRoot) {
            this.project.addTestCompileSourceRoot(this.getCompileSourceRoot());
        }
    }

    private void adjustAdditionalProperties(CodegenConfig config) {
        Map configAdditionalProperties = config.additionalProperties();
        Set keySet = configAdditionalProperties.keySet();
        for (String key : keySet) {
            Object value = configAdditionalProperties.get(key);
            if (value != null) {
                if (!(value instanceof String)) continue;
                String stringValue = (String)value;
                if (stringValue.equalsIgnoreCase("true")) {
                    configAdditionalProperties.put(key, Boolean.TRUE);
                    continue;
                }
                if (!stringValue.equalsIgnoreCase("false")) continue;
                configAdditionalProperties.put(key, Boolean.FALSE);
                continue;
            }
            configAdditionalProperties.put(key, Boolean.FALSE);
        }
    }
}

