/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.netpreserve.jwarc.GeminiParser;
import org.netpreserve.jwarc.LengthedBody;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.Message;
import org.netpreserve.jwarc.MessageBody;
import org.netpreserve.jwarc.MessageHeaders;
import org.netpreserve.jwarc.MessageVersion;

public class GeminiResponse
extends Message {
    private final int status;
    private final String meta;

    public GeminiResponse(int status, String meta, MessageBody body) {
        super(MessageVersion.GEMINI, new MessageHeaders(Collections.emptyMap()), body);
        this.status = status;
        this.meta = meta;
    }

    public static GeminiResponse parse(ReadableByteChannel channel, ByteBuffer buffer) throws IOException {
        GeminiParser parser = new GeminiParser();
        parser.strictResponse();
        parser.parse(channel, buffer, null);
        return new GeminiResponse(parser.status(), parser.meta(), (MessageBody)LengthedBody.createFromContentLength(channel, buffer, null));
    }

    public int status() {
        return this.status;
    }

    public int statusHttpEquivalent() {
        switch (this.status) {
            case 20: {
                return 200;
            }
            case 31: {
                return 307;
            }
            case 32: {
                return 308;
            }
            case 40: {
                return 503;
            }
            case 41: {
                return 503;
            }
            case 42: {
                return 500;
            }
            case 43: {
                return 502;
            }
            case 44: {
                return 429;
            }
            case 50: {
                return 500;
            }
            case 51: {
                return 404;
            }
            case 52: {
                return 410;
            }
            case 53: {
                return 502;
            }
            case 59: {
                return 400;
            }
            case 60: {
                return 401;
            }
            case 61: {
                return 403;
            }
            case 62: {
                return 403;
            }
        }
        if (this.status > 10 && this.status < 20) {
            return 100;
        }
        if (this.status >= 20 && this.status < 30) {
            return 200;
        }
        if (this.status >= 30 && this.status < 40) {
            return 307;
        }
        if (this.status >= 60 && this.status < 70) {
            return 401;
        }
        return 500;
    }

    public String meta() {
        return this.meta;
    }

    @Override
    public byte[] serializeHeader() {
        return (String.format("%02d", this.status) + " " + this.meta + "\r\n").getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public MediaType contentType() {
        if (this.status >= 20 && this.status < 30) {
            if (this.meta.isEmpty()) {
                return MediaType.parse("text/gemini; charset=utf-8");
            }
            return MediaType.parse(this.meta);
        }
        return MediaType.OCTET_STREAM;
    }
}

