/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.results.memory.RuntimeMemoryCCTNode;

public class RuntimeObjAllocTermCCTNode
extends RuntimeMemoryCCTNode {
    public long nCalls;
    public long totalObjSize;

    public RuntimeObjAllocTermCCTNode(int methodId) {
        super(methodId);
    }

    protected RuntimeObjAllocTermCCTNode() {
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public void readFromStream(DataInputStream in) throws IOException {
        super.readFromStream(in);
        this.nCalls = in.readLong();
        this.totalObjSize = in.readLong();
    }

    public void updateForNewObject(long objSize) {
        ++this.nCalls;
        this.totalObjSize += objSize;
    }

    public void updateForRemovedObject(long objSize) {
        this.totalObjSize -= objSize;
    }

    @Override
    public void writeToStream(DataOutputStream out) throws IOException {
        super.writeToStream(out);
        out.writeLong(this.nCalls);
        out.writeLong(this.totalObjSize);
    }
}

