/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.ClassDumpInstance;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.InstanceDump;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.LongSet;
import org.netbeans.lib.profiler.heap.ObjectArrayDump;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Systems;

class TreeObject {
    private static final int BUFFER_SIZE = 8192;
    private HprofHeap heap;
    private LongBuffer readBuffer;
    private LongBuffer writeBuffer;
    private Set<Long> unique;

    TreeObject(HprofHeap h, LongBuffer leaves) {
        this.heap = h;
        this.writeBuffer = leaves;
    }

    synchronized void computeTrees() {
        try {
            boolean changed;
            this.createBuffers();
            do {
                this.switchBuffers();
            } while (changed = this.computeOneLevel());
        }
        catch (IOException ex) {
            Systems.printStackTrace(ex);
        }
        this.deleteBuffers();
    }

    private boolean computeOneLevel() throws IOException {
        boolean changed = false;
        int idSize = this.heap.dumpBuffer.getIDSize();
        while (true) {
            List fieldValues;
            long instanceId = this.readLong();
            long retainedSize = 0L;
            if (instanceId == 0L) break;
            Instance instance = this.heap.getInstanceByID(instanceId);
            if (instance instanceof ObjectArrayInstance) {
                ObjectArrayDump array = (ObjectArrayDump)instance;
                int arrSize = array.getLength();
                long offset = array.getOffset();
                long size = 0L;
                LongSet refs = new LongSet();
                for (int i = 0; i < arrSize && size != -1L; ++i) {
                    long refInstanceId = this.heap.dumpBuffer.getID(offset + (long)(i * idSize));
                    size = this.checkInstance(instanceId, refInstanceId, refs);
                    retainedSize += size;
                }
                changed |= this.processInstance(instance, size, retainedSize);
                continue;
            }
            if (instance instanceof PrimitiveArrayInstance) {
                assert (false) : "Error - PrimitiveArrayInstance not allowed " + instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
                continue;
            }
            if (instance instanceof ClassDumpInstance) {
                ClassDump javaClass = ((ClassDumpInstance)instance).classDump;
                fieldValues = javaClass.getStaticFieldValues();
            } else if (instance instanceof InstanceDump) {
                fieldValues = instance.getFieldValues();
            } else {
                if (instance == null) {
                    Systems.debug("HeapWalker Warning - null instance for " + instanceId);
                    continue;
                }
                throw new IllegalArgumentException("Illegal type " + instance.getClass());
            }
            long size = 0L;
            LongSet refs = new LongSet();
            Iterator valuesIt = fieldValues.iterator();
            while (valuesIt.hasNext() && size != -1L) {
                FieldValue val = (FieldValue)valuesIt.next();
                if (!(val instanceof ObjectFieldValue)) continue;
                Instance refInstance = ((ObjectFieldValue)val).getInstance();
                size = this.checkInstance(instanceId, refInstance, refs);
                retainedSize += size;
            }
            changed |= this.processInstance(instance, size, retainedSize);
        }
        return changed;
    }

    private boolean processInstance(Instance instance, long size, long retainedSize) throws IOException {
        if (size != -1L) {
            long gcRootPointer;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instance.getInstanceId());
            entry.setRetainedSize((int)(instance.getSize() + retainedSize));
            entry.setTreeObj();
            if (entry.hasOnlyOneReference() && (gcRootPointer = entry.getNearestGCRootPointer()) != 0L && this.unique.add(gcRootPointer)) {
                this.writeLong(gcRootPointer);
            }
            return true;
        }
        return false;
    }

    private void createBuffers() {
        this.readBuffer = new LongBuffer(8192, this.heap.cacheDirectory);
    }

    private void deleteBuffers() {
        this.readBuffer.delete();
        this.writeBuffer.delete();
    }

    private long readLong() throws IOException {
        return this.readBuffer.readLong();
    }

    private void switchBuffers() throws IOException {
        LongBuffer b = this.readBuffer;
        this.readBuffer = this.writeBuffer;
        this.writeBuffer = b;
        this.readBuffer.startReading();
        this.writeBuffer.reset();
        this.unique = new HashSet<Long>(4000);
    }

    private void writeLong(long instanceId) throws IOException {
        if (instanceId != 0L) {
            this.writeBuffer.writeLong(instanceId);
        }
    }

    private long checkInstance(long instanceId, Instance refInstance, LongSet refs) throws IOException {
        if (refInstance != null) {
            return this.checkInstance(instanceId, refInstance.getInstanceId(), refs);
        }
        return 0L;
    }

    private long checkInstance(long instanceId, long refInstanceId, LongSet refs) throws IOException {
        if (refInstanceId != 0L) {
            LongMap.Entry refEntry = this.heap.idToOffsetMap.get(refInstanceId);
            if (refEntry == null) {
                return 0L;
            }
            if (!refEntry.hasOnlyOneReference()) {
                return -1L;
            }
            if (!refEntry.isTreeObj()) {
                return -1L;
            }
            if (refs.add(refInstanceId)) {
                return 0L;
            }
            return refEntry.getRetainedSize();
        }
        return 0L;
    }
}

