/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.ApocConfig;
import apoc.SystemPropertyKeys;
import apoc.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class SystemDbUtil {
    public static final String SYS_NON_LEADER_ERROR = "It's not possible to write into a cluster member with a non-LEADER system database.\n";
    public static final String PROCEDURE_NOT_ROUTED_ERROR = "No write operations are allowed directly on this database. Writes must pass through the leader. The role of this server is: FOLLOWER";
    public static final String DB_NOT_FOUND_ERROR = "The user database with name '%s' does not exist";
    public static final String BAD_TARGET_ERROR = " can only be installed on user databases.";

    public static void checkWriteAllowed(String msgDeprecation) {
        GraphDatabaseAPI sysDb = (GraphDatabaseAPI)ApocConfig.apocConfig().getSystemDb();
        if (!Util.isWriteableInstance((GraphDatabaseAPI)sysDb)) {
            throw new RuntimeException(SYS_NON_LEADER_ERROR + msgDeprecation);
        }
    }

    public static void checkInSystemLeader(GraphDatabaseService db) {
        GraphDatabaseAPI sysDb = (GraphDatabaseAPI)ApocConfig.apocConfig().getSystemDb();
        if (!db.databaseName().equals("system") || !Util.isWriteableInstance((GraphDatabaseAPI)sysDb)) {
            throw new RuntimeException(PROCEDURE_NOT_ROUTED_ERROR);
        }
    }

    public static void checkTargetDatabase(Transaction tx, String databaseName, String type) {
        Set databases = tx.execute("SHOW DATABASES", Collections.emptyMap()).columnAs("name").stream().collect(Collectors.toSet());
        if (!databases.contains(databaseName)) {
            throw new RuntimeException(String.format(DB_NOT_FOUND_ERROR, databaseName));
        }
        if (databaseName.equals("system")) {
            throw new RuntimeException(type + BAD_TARGET_ERROR);
        }
    }

    public static <T> T withSystemDb(Function<Transaction, T> action) {
        try (Transaction tx = ApocConfig.apocConfig().getSystemDb().beginTx();){
            T result = action.apply(tx);
            tx.commit();
            T t = result;
            return t;
        }
    }

    public static void withSystemDb(Consumer<Transaction> consumer) {
        try (Transaction tx = ApocConfig.apocConfig().getSystemDb().beginTx();){
            consumer.accept(tx);
            tx.commit();
        }
    }

    public static ResourceIterator<Node> getSystemNodes(Transaction tx, String databaseName, Label sysLabel, Map<String, Object> props) {
        String dbNameKey = SystemPropertyKeys.database.name();
        if (props == null) {
            return tx.findNodes(sysLabel, dbNameKey, (Object)databaseName);
        }
        HashMap<String, Object> propsMap = new HashMap<String, Object>();
        propsMap.put(dbNameKey, databaseName);
        propsMap.putAll(props);
        return tx.findNodes(sysLabel, propsMap);
    }

    public static void setLastUpdate(Transaction tx, String databaseName, Label label) {
        Node node = tx.findNode(label, SystemPropertyKeys.database.name(), (Object)databaseName);
        if (node == null) {
            node = tx.createNode(new Label[]{label});
            node.setProperty(SystemPropertyKeys.database.name(), (Object)databaseName);
        }
        long value = System.currentTimeMillis();
        node.setProperty(SystemPropertyKeys.lastUpdated.name(), (Object)value);
    }

    public static long getLastUpdate(String databaseName, Label label) {
        return SystemDbUtil.withSystemDb((Transaction tx) -> {
            Node node = tx.findNode(label, SystemPropertyKeys.database.name(), (Object)databaseName);
            return node == null ? 0L : (Long)node.getProperty(SystemPropertyKeys.lastUpdated.name());
        });
    }
}

