/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.export.cypher.formatter.CypherFormatterUtils;
import apoc.util.Util;
import java.math.BigInteger;
import java.time.Duration;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.stream.LongStream;
import org.neo4j.graphdb.Entity;

public class ExtendedUtil {
    public static String dateFormat(TemporalAccessor value, String format) {
        return Util.getFormat((String)format).format(value);
    }

    public static double doubleValue(Entity pc, String prop, Number defaultValue) {
        return Util.toDouble((Object)pc.getProperty(prop, (Object)defaultValue));
    }

    public static Duration durationParse(String value) {
        return Duration.parse(value);
    }

    public static boolean isSumOutOfRange(long ... numbers) {
        try {
            ExtendedUtil.sumLongs(numbers).longValueExact();
            return false;
        }
        catch (ArithmeticException ae) {
            return true;
        }
    }

    private static BigInteger sumLongs(long ... numbers) {
        return LongStream.of(numbers).mapToObj(BigInteger::valueOf).reduce(BigInteger.ZERO, (x, y) -> x.add((BigInteger)y));
    }

    public static String toCypherMap(Map<String, Object> map) {
        StringBuilder builder = CypherFormatterUtils.formatProperties(map);
        return "{" + CypherFormatterUtils.formatToString((StringBuilder)builder) + "}";
    }
}

