/*
 * Decompiled with CFR 0.152.
 */
package apoc.ttl;

import apoc.ApocConfig;
import apoc.TTLConfig;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class TTLLifeCycle
extends LifecycleAdapter {
    public static final int INITIAL_DELAY = 30;
    public static final int DEFAULT_SCHEDULE = 60;
    private static final Group TTL_GROUP = Group.INDEX_UPDATING;
    private final JobScheduler scheduler;
    private final GraphDatabaseAPI db;
    private final ApocConfig apocConfig;
    private JobHandle ttlIndexJobHandle;
    private JobHandle ttlJobHandle;
    private TTLConfig ttlConfig;
    private Log log;

    public TTLLifeCycle(JobScheduler scheduler, GraphDatabaseAPI db, ApocConfig apocConfig, TTLConfig ttlConfig, Log log) {
        this.scheduler = scheduler;
        this.db = db;
        this.apocConfig = apocConfig;
        this.ttlConfig = ttlConfig;
        this.log = log;
    }

    public void start() {
        TTLConfig.Values configValues = this.ttlConfig.configFor(this.db);
        if (configValues.enabled) {
            long ttlScheduleDb = configValues.schedule;
            this.ttlIndexJobHandle = this.scheduler.schedule(TTL_GROUP, this::createTTLIndex, (long)((int)((double)ttlScheduleDb * 0.8)), TimeUnit.SECONDS);
            long limitDb = configValues.limit;
            this.ttlJobHandle = this.scheduler.scheduleRecurring(TTL_GROUP, () -> this.expireNodes(limitDb), ttlScheduleDb, ttlScheduleDb, TimeUnit.SECONDS);
        }
    }

    public void expireNodes(long limit) {
        try {
            if (!Util.isWriteableInstance((GraphDatabaseAPI)this.db)) {
                return;
            }
            String matchTTL = "MATCH (t:TTL) WHERE t.ttl < timestamp() ";
            String queryRels = matchTTL + "WITH t MATCH (t)-[r]-() RETURN id(r) as id";
            String queryNodes = matchTTL + "RETURN id(t) as id";
            Map params = Util.map((Object[])new Object[]{"batchSize", limit, "queryRels", queryRels, "queryNodes", queryNodes});
            long relationshipsDeleted = (Long)this.db.executeTransactionally("CALL apoc.periodic.iterate($queryRels, 'MATCH ()-[r]->() WHERE id(r) = id DELETE r', {batchSize: $batchSize})", params, result -> (Long)Iterators.single((Iterator)result.columnAs("total")));
            long nodesDeleted = (Long)this.db.executeTransactionally("CALL apoc.periodic.iterate($queryNodes, 'MATCH (n) WHERE id(n) = id DETACH DELETE n', {batchSize: $batchSize})", params, result -> (Long)Iterators.single((Iterator)result.columnAs("total")));
            if (nodesDeleted > 0L) {
                this.log.info("TTL: Expired %d nodes %d relationships", new Object[]{nodesDeleted, relationshipsDeleted});
            }
        }
        catch (Exception e) {
            this.log.error("TTL: Error deleting expired nodes", (Throwable)e);
        }
    }

    public void createTTLIndex() {
        try {
            this.db.executeTransactionally("call apoc.schema.assert({ TTL: ['ttl'] }, null, false)");
        }
        catch (Exception e) {
            this.log.error("TTL: Error creating index", (Throwable)e);
        }
    }

    public void stop() {
        if (this.ttlIndexJobHandle != null) {
            this.ttlIndexJobHandle.cancel();
        }
        if (this.ttlJobHandle != null) {
            this.ttlJobHandle.cancel();
        }
    }
}

