/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.Description;
import apoc.Extended;
import apoc.Pools;
import apoc.periodic.PeriodicUtils;
import apoc.util.Util;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class PeriodicExtended {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;
    @Context
    public Pools pools;

    @Procedure(mode=Mode.SCHEMA)
    @Description(value="apoc.periodic.submitSchema(name, statement, $config) - equivalent to apoc.periodic.submit which can also accept schema operations")
    public Stream<PeriodicUtils.JobInfo> submitSchema(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="params", defaultValue="{}") Map<String, Object> config) {
        this.validateQuery(statement);
        return PeriodicUtils.submitProc((String)name, (String)statement, config, (GraphDatabaseService)this.db, (Log)this.log, (Pools)this.pools);
    }

    private void validateQuery(String statement) {
        Util.validateQuery((GraphDatabaseService)this.db, (String)statement, (QueryExecutionType.QueryType[])new QueryExecutionType.QueryType[]{QueryExecutionType.QueryType.READ_ONLY, QueryExecutionType.QueryType.WRITE, QueryExecutionType.QueryType.READ_WRITE, QueryExecutionType.QueryType.SCHEMA_WRITE});
    }
}

