/*
 * Decompiled with CFR 0.152.
 */
package apoc.ml;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.result.MapResult;
import apoc.util.JsonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class OpenAI {
    @Context
    public ApocConfig apocConfig;
    public static final String APOC_ML_OPENAI_URL = "apoc.ml.openai.url";

    static Stream<Object> executeRequest(String apiKey, Map<String, Object> configuration, String path, String model, String key, Object inputs, String jsonPath, ApocConfig apocConfig) throws JsonProcessingException, MalformedURLException {
        if ((apiKey = apocConfig.getString("apoc.openai.key", apiKey)) == null || apiKey.isBlank()) {
            throw new IllegalArgumentException("API Key must not be empty");
        }
        String endpoint = System.getProperty(APOC_ML_OPENAI_URL, "https://api.openai.com/v1/");
        Map<String, CallSite> headers = Map.of("Content-Type", "application/json", "Authorization", "Bearer " + apiKey);
        HashMap<String, Object> config = new HashMap<String, Object>(configuration);
        config.putIfAbsent("model", model);
        config.put(key, inputs);
        String payload = new ObjectMapper().writeValueAsString(config);
        String url = new URL(new URL(endpoint), path).toString();
        return JsonUtil.loadJson((Object)url, headers, (String)payload, (String)jsonPath, (boolean)true, List.of());
    }

    @Procedure(value="apoc.ml.openai.embedding")
    @Description(value="apoc.openai.embedding([texts], api_key, configuration) - returns the embeddings for a given text")
    public Stream<EmbeddingResult> getEmbedding(@Name(value="texts") List<String> texts, @Name(value="api_key") String apiKey, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        Stream<Object> resultStream = OpenAI.executeRequest(apiKey, configuration, "embeddings", "text-embedding-ada-002", "input", texts, "$.data", this.apocConfig);
        return resultStream.flatMap(v -> ((List)v).stream()).map(m -> {
            Long index = (Long)m.get("index");
            return new EmbeddingResult(index, (String)texts.get(index.intValue()), (List)m.get("embedding"));
        });
    }

    @Procedure(value="apoc.ml.openai.completion")
    @Description(value="apoc.ml.openai.completion(prompt, api_key, configuration) - prompts the completion API")
    public Stream<MapResult> completion(@Name(value="prompt") String prompt, @Name(value="api_key") String apiKey, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return OpenAI.executeRequest(apiKey, configuration, "completions", "text-davinci-003", "prompt", prompt, "$", this.apocConfig).map(v -> (Map)v).map(MapResult::new);
    }

    @Procedure(value="apoc.ml.openai.chat")
    @Description(value="apoc.ml.openai.chat(messages, api_key, configuration]) - prompts the completion API")
    public Stream<MapResult> chatCompletion(@Name(value="messages") List<Map<String, Object>> messages, @Name(value="api_key") String apiKey, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) throws Exception {
        return OpenAI.executeRequest(apiKey, configuration, "chat/completions", "gpt-3.5-turbo", "messages", messages, "$", this.apocConfig).map(v -> (Map)v).map(MapResult::new);
    }

    public static class EmbeddingResult {
        public final long index;
        public final String text;
        public final List<Double> embedding;

        public EmbeddingResult(long index, String text, List<Double> embedding) {
            this.index = index;
            this.text = text;
            this.embedding = embedding;
        }
    }
}

