/*
 * Decompiled with CFR 0.152.
 */
package apoc.load.util;

import apoc.util.Util;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Map;

public class LoadJdbcConfig {
    private ZoneId zoneId = null;
    private Credentials credentials;
    private final Long fetchSize;
    private final boolean autoCommit;

    public LoadJdbcConfig(Map<String, Object> config) {
        config = config != null ? config : Collections.emptyMap();
        try {
            this.zoneId = config.containsKey("timezone") ? ZoneId.of(config.get("timezone").toString()) : null;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(String.format("The timezone field contains an error: %s", e.getMessage()));
        }
        this.credentials = config.containsKey("credentials") ? LoadJdbcConfig.createCredentials((Map)config.get("credentials")) : null;
        this.fetchSize = Util.toLong((Object)config.getOrDefault("fetchSize", 5000L));
        this.autoCommit = Util.toBoolean((Object)config.getOrDefault("autoCommit", false));
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public static Credentials createCredentials(Map<String, String> credentials) {
        if (!credentials.getOrDefault("user", "").equals("") && !credentials.getOrDefault("password", "").equals("")) {
            return new Credentials(credentials.get("user"), credentials.get("password"));
        }
        throw new IllegalArgumentException("In config param credentials must be passed both user and password.");
    }

    public boolean hasCredentials() {
        return this.credentials != null;
    }

    public Long getFetchSize() {
        return this.fetchSize;
    }

    public boolean isAutoCommit() {
        return this.autoCommit;
    }

    public static class Credentials {
        private String user;
        private String password;

        public Credentials(String user, String password) {
            this.user = user;
            this.password = password;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

