/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.ApocConfig;
import apoc.Extended;
import apoc.load.LDAPResult;
import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class LoadLdap {
    @Procedure(name="apoc.load.ldap", mode=Mode.READ)
    @Description(value="apoc.load.ldap(\"key\" or {connectionMap},{searchMap}) Load entries from an ldap source (yield entry)")
    public Stream<LDAPResult> ldapQuery(@Name(value="connection") Object conn, @Name(value="search") Map<String, Object> search) {
        LDAPManager mgr = new LDAPManager(LoadLdap.getConnectionMap(conn));
        return mgr.executeSearch(search);
    }

    public static Map<String, Object> getConnectionMap(Object conn) {
        if (conn instanceof String) {
            String value = ApocConfig.apocConfig().getString("apoc.loadldap" + conn.toString() + ".config");
            if (value == null) {
                throw new RuntimeException("No apoc.loadldap." + conn + ".config ldap access configuration specified");
            }
            HashMap<String, Object> config = new HashMap<String, Object>();
            String[] sConf = value.split(" ");
            config.put("ldapHost", sConf[0]);
            config.put("loginDN", sConf[1]);
            config.put("loginPW", sConf[2]);
            return config;
        }
        return (Map)conn;
    }

    public static class LDAPManager {
        private static final String LDAP_HOST_P = "ldapHost";
        private static final String LDAP_LOGIN_DN_P = "loginDN";
        private static final String LDAP_LOGIN_PW_P = "loginPW";
        private static final String SEARCH_BASE_P = "searchBase";
        private static final String SEARCH_SCOPE_P = "searchScope";
        private static final String SEARCH_FILTER_P = "searchFilter";
        private static final String SEARCH_ATTRIBUTES_P = "attributes";
        private static final String SCOPE_BASE = "SCOPE_BASE";
        private static final String SCOPE_ONE = "SCOPE_ONE";
        private static final String SCOPE_SUB = "SCOPE_SUB";
        private int ldapPort;
        private int ldapVersion = 3;
        private String ldapHost;
        private String loginDN;
        private String password;
        private LDAPConnection lc;
        private List<String> attributeList;

        public LDAPManager(Map<String, Object> connParms) {
            String sLdapHostPort = (String)connParms.get(LDAP_HOST_P);
            if (sLdapHostPort.indexOf(":") > -1) {
                this.ldapHost = sLdapHostPort.substring(0, sLdapHostPort.indexOf(":"));
                this.ldapPort = Integer.parseInt(sLdapHostPort.substring(sLdapHostPort.indexOf(":") + 1));
            } else {
                this.ldapHost = sLdapHostPort;
                this.ldapPort = 389;
            }
            this.loginDN = (String)connParms.get(LDAP_LOGIN_DN_P);
            this.password = (String)connParms.get(LDAP_LOGIN_PW_P);
        }

        public Stream<LDAPResult> executeSearch(Map<String, Object> search) {
            try {
                SearchResultsIterator supplier = new SearchResultsIterator(this.doSearch(search), this.attributeList);
                Spliterator<Map<String, Object>> spliterator = Spliterators.spliteratorUnknownSize(supplier, 16);
                return (Stream)StreamSupport.stream(spliterator, false).map(LDAPResult::new).onClose(() -> LDAPManager.closeIt(this.lc));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public LDAPSearchResults doSearch(Map<String, Object> search) {
            String searchBase = (String)search.get(SEARCH_BASE_P);
            String searchFilter = (String)search.get(SEARCH_FILTER_P);
            String sScope = (String)search.get(SEARCH_SCOPE_P);
            this.attributeList = (List)search.get(SEARCH_ATTRIBUTES_P);
            if (this.attributeList == null) {
                this.attributeList = new ArrayList<String>();
            }
            int searchScope = 2;
            if (sScope.equals(SCOPE_BASE)) {
                searchScope = 0;
            } else if (sScope.equals(SCOPE_ONE)) {
                searchScope = 1;
            } else if (sScope.equals(SCOPE_SUB)) {
                searchScope = 2;
            } else {
                throw new RuntimeException("Invalid scope:" + sScope + ". value scopes are SCOPE_BASE, SCOPE_ONE and SCOPE_SUB");
            }
            try {
                this.lc = this.getConnection();
                LDAPSearchConstraints cons = new LDAPSearchConstraints();
                cons.setMaxResults(0);
                LDAPSearchResults searchResults = null;
                searchResults = this.attributeList == null || this.attributeList.size() == 0 ? this.lc.search(searchBase, searchScope, searchFilter, null, false, cons) : this.lc.search(searchBase, searchScope, searchFilter, this.attributeList.toArray(new String[0]), false, cons);
                return searchResults;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static void closeIt(LDAPConnection lc) {
            try {
                lc.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private LDAPConnection getConnection() throws LDAPException, UnsupportedEncodingException {
            LDAPConnection lc = new LDAPConnection();
            lc.connect(this.ldapHost, this.ldapPort);
            lc.bind(this.ldapVersion, this.loginDN, this.password.getBytes("UTF8"));
            return lc;
        }
    }

    private static class SearchResultsIterator
    implements Iterator<Map<String, Object>> {
        private final LDAPSearchResults lsr;
        private final List<String> attributes;
        private Map<String, Object> map;

        public SearchResultsIterator(LDAPSearchResults lsr, List<String> attributes) {
            this.lsr = lsr;
            this.attributes = attributes;
            this.map = this.get();
        }

        @Override
        public boolean hasNext() {
            return this.map != null;
        }

        @Override
        public Map<String, Object> next() {
            Map<String, Object> current = this.map;
            this.map = this.get();
            return current;
        }

        public Map<String, Object> get() {
            if (this.handleEndOfResults()) {
                return null;
            }
            try {
                LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(this.attributes.size() + 1);
                LDAPEntry en = null;
                en = this.lsr.next();
                entry.put("dn", en.getDN());
                if (this.attributes != null && this.attributes.size() > 0) {
                    for (int col = 0; col < this.attributes.size(); ++col) {
                        Object val = this.readValue(en.getAttributeSet().getAttribute(this.attributes.get(col)));
                        if (val == null) continue;
                        entry.put(this.attributes.get(col), val);
                    }
                } else {
                    for (LDAPAttribute attr : en.getAttributeSet()) {
                        Object val = this.readValue(attr);
                        if (val == null) continue;
                        entry.put(attr.getName(), this.readValue(attr));
                    }
                }
                return entry;
            }
            catch (LDAPException e) {
                throw new RuntimeException("Error getting next ldap entry " + e.getLDAPErrorMessage());
            }
        }

        private boolean handleEndOfResults() {
            return !this.lsr.hasMore();
        }

        private Object readValue(LDAPAttribute att) {
            if (att == null) {
                return null;
            }
            if (att.size() == 1) {
                return att.getStringValue();
            }
            return att.getStringValueArray();
        }
    }
}

