/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.load.LoadHtmlConfig;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class LoadHtmlBrowser {
    public static InputStream getChromeInputStream(String url, Map<String, String> query, LoadHtmlConfig config, boolean isHeadless, boolean isAcceptInsecureCerts) {
        LoadHtmlBrowser.setupWebDriverManager(WebDriverManager.chromedriver(), config);
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.addArguments(new String[]{"--headless=new"});
        chromeOptions.setAcceptInsecureCerts(isAcceptInsecureCerts);
        return LoadHtmlBrowser.getInputStreamWithBrowser(url, query, config, (WebDriver)new ChromeDriver(chromeOptions));
    }

    public static InputStream getFirefoxInputStream(String url, Map<String, String> query, LoadHtmlConfig config, boolean isHeadless, boolean isAcceptInsecureCerts) {
        LoadHtmlBrowser.setupWebDriverManager(WebDriverManager.firefoxdriver(), config);
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.addArguments(new String[]{"-headless"});
        firefoxOptions.setAcceptInsecureCerts(isAcceptInsecureCerts);
        return LoadHtmlBrowser.getInputStreamWithBrowser(url, query, config, (WebDriver)new FirefoxDriver(firefoxOptions));
    }

    private static void setupWebDriverManager(WebDriverManager driver, LoadHtmlConfig config) {
        Optional.ofNullable(config.getDriverVersion()).ifPresent(arg_0 -> ((WebDriverManager)driver).driverVersion(arg_0));
        Optional.ofNullable(config.getBrowserVersion()).ifPresent(arg_0 -> ((WebDriverManager)driver).browserVersion(arg_0));
        Optional.ofNullable(config.getCachePath()).ifPresent(arg_0 -> ((WebDriverManager)driver).cachePath(arg_0));
        Optional.ofNullable(config.getResolutionCachePath()).ifPresent(arg_0 -> ((WebDriverManager)driver).resolutionCachePath(arg_0));
        Optional.ofNullable(config.getProxy()).ifPresent(arg_0 -> ((WebDriverManager)driver).proxy(arg_0));
        Optional.ofNullable(config.getProxyUser()).ifPresent(arg_0 -> ((WebDriverManager)driver).proxyUser(arg_0));
        Optional.ofNullable(config.getProxyPass()).ifPresent(arg_0 -> ((WebDriverManager)driver).proxyPass(arg_0));
        Optional.ofNullable(config.getGitHubToken()).ifPresent(arg_0 -> ((WebDriverManager)driver).gitHubToken(arg_0));
        Optional.ofNullable(config.getDriverRepositoryUrl()).ifPresent(c -> driver.driverRepositoryUrl(LoadHtmlBrowser.fromUrl(c)));
        Optional.ofNullable(config.getVersionsPropertiesUrl()).ifPresent(c -> driver.versionsPropertiesUrl(LoadHtmlBrowser.fromUrl(c)));
        Optional.ofNullable(config.getCommandsPropertiesUrl()).ifPresent(c -> driver.commandsPropertiesUrl(LoadHtmlBrowser.fromUrl(c)));
        Optional.ofNullable(config.getOperatingSystem()).ifPresent(c -> driver.operatingSystem(OperatingSystem.valueOf((String)c)));
        Optional.ofNullable(config.getArchitecture()).ifPresent(c -> driver.architecture(Architecture.valueOf((String)c)));
        if (config.isForceDownload()) {
            driver.forceDownload();
        }
        if (config.isUseBetaVersions()) {
            driver.useBetaVersions();
        }
        if (config.isUseMirror()) {
            driver.useMirror();
        }
        if (config.isAvoidExport()) {
            driver.avoidExport();
        }
        if (config.isAvoidOutputTree()) {
            driver.avoidOutputTree();
        }
        if (config.isClearDriverCache()) {
            driver.clearDriverCache();
        }
        if (config.isClearResolutionCache()) {
            driver.clearResolutionCache();
        }
        if (config.isAvoidFallback()) {
            driver.avoidFallback();
        }
        if (config.isAvoidBrowserDetection()) {
            driver.avoidBrowserDetection();
        }
        if (config.isAvoidReadReleaseFromRepository()) {
            driver.avoidReadReleaseFromRepository();
        }
        if (config.isAvoidTmpFolder()) {
            driver.avoidTmpFolder();
        }
        if (config.isUseLocalVersionsPropertiesFirst()) {
            driver.useLocalVersionsPropertiesFirst();
        }
        Optional.ofNullable(config.getTimeout()).ifPresent(arg_0 -> ((WebDriverManager)driver).timeout(arg_0));
        Optional.ofNullable(config.getTtl()).ifPresent(arg_0 -> ((WebDriverManager)driver).ttl(arg_0));
        Optional.ofNullable(config.getTtlBrowsers()).ifPresent(arg_0 -> ((WebDriverManager)driver).ttlBrowsers(arg_0));
        driver.setup();
    }

    private static URL fromUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static InputStream getInputStreamWithBrowser(String url, Map<String, String> query, LoadHtmlConfig config, WebDriver driver) {
        driver.get(url);
        long wait = config.getWait();
        if (wait > 0L) {
            WebDriverWait driverWait = new WebDriverWait(driver, Duration.ofSeconds(wait));
            try {
                driverWait.until(webDriver -> query.values().stream().noneMatch(selector -> webDriver.findElements(By.cssSelector((String)selector)).isEmpty()));
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        InputStream stream = IOUtils.toInputStream((String)driver.getPageSource(), (String)config.getCharset());
        driver.close();
        return stream;
    }
}

