/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.utils;

import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;

public class WeightedReservoirSampler {
    private final Random random = new Random();

    public int randomIndexChoice(List<Integer> weights) {
        int result = 0;
        double maxKey = 0.0;
        ListIterator<Integer> it = weights.listIterator();
        while (it.hasNext()) {
            int index = it.nextIndex();
            int weight = it.next();
            double u = this.random.nextDouble();
            double key = Math.pow(u, 1.0 / (double)weight);
            if (!(key > maxKey)) continue;
            maxKey = key;
            result = index;
        }
        return result;
    }

    public int randomIndexChoice(List<Integer> weights, Set<Integer> omitIndices) {
        int result = 0;
        double maxKey = 0.0;
        ListIterator<Integer> it = weights.listIterator();
        while (it.hasNext()) {
            double u;
            double key;
            int index = it.nextIndex();
            int weight = it.next();
            if (omitIndices.contains(index) || !((key = Math.pow(u = this.random.nextDouble(), 1.0 / (double)weight)) > maxKey)) continue;
            maxKey = key;
            result = index;
        }
        return result;
    }

    public int randomIndexChoice(List<Integer> weights, int omit) {
        int result = 0;
        double maxKey = 0.0;
        ListIterator<Integer> it = weights.listIterator();
        while (it.hasNext()) {
            double u;
            double key;
            int index = it.nextIndex();
            int weight = it.next();
            if (index == omit || !((key = Math.pow(u = this.random.nextDouble(), 1.0 / (double)weight)) > maxKey)) continue;
            maxKey = key;
            result = index;
        }
        return result;
    }
}

