/*
 * Decompiled with CFR 0.152.
 */
package apoc.generate.relationship;

import apoc.generate.config.DistributionBasedConfig;
import apoc.generate.distribution.MutableSimpleDegreeDistribution;
import apoc.generate.relationship.BaseRelationshipGenerator;
import apoc.generate.utils.WeightedReservoirSampler;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class SimpleGraphRelationshipGenerator
extends BaseRelationshipGenerator<DistributionBasedConfig> {
    public SimpleGraphRelationshipGenerator(DistributionBasedConfig configuration) {
        super(configuration);
    }

    @Override
    protected List<Pair<Integer, Integer>> doGenerateEdges() {
        ArrayList<Pair<Integer, Integer>> edges = new ArrayList<Pair<Integer, Integer>>();
        MutableSimpleDegreeDistribution distribution = new MutableSimpleDegreeDistribution(((DistributionBasedConfig)this.getConfiguration()).getDegrees());
        while (!distribution.isZeroList()) {
            Pair edgeCandidate;
            MutableSimpleDegreeDistribution temp;
            int index = 0;
            long min = Long.MAX_VALUE;
            for (int i = 0; i < distribution.size(); ++i) {
                long elem = distribution.get(i);
                if (elem == 0L || elem >= min) continue;
                min = elem;
                index = i;
            }
            WeightedReservoirSampler sampler = new WeightedReservoirSampler();
            while (true) {
                temp = new MutableSimpleDegreeDistribution(distribution.getDegrees());
                int candidateIndex = sampler.randomIndexChoice(temp.getDegrees(), index);
                edgeCandidate = Pair.of((Object)candidateIndex, (Object)index);
                boolean skip = false;
                for (Pair pair : edges) {
                    if (!pair.equals((Object)edgeCandidate)) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                temp.decrease(index);
                temp.decrease(candidateIndex);
                if (temp.isValid()) break;
            }
            distribution = temp;
            edges.add((Pair<Integer, Integer>)edgeCandidate);
        }
        return edges;
    }
}

