/*
 * Decompiled with CFR 0.152.
 */
package apoc.dv;

import apoc.dv.VirtualizedResource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class JDBCResource
extends VirtualizedResource {
    private final String queryParsed;

    public JDBCResource(String name, Map<String, Object> config) {
        super(name, (String)config.get("url"), (String)config.get("desc"), (List)config.get("labels"), (String)config.get("query"), JDBCResource.getParameters(config), "JDBC");
        this.queryParsed = JDBCResource.parseQuery(config);
    }

    private static List<String> getParameters(Map<String, Object> config) {
        String query = (String)config.get("query");
        long questionMarks = JDBCResource.countForQuestionMarks(query);
        if (questionMarks > 0L) {
            return LongStream.range(0L, questionMarks).mapToObj(i -> "?").collect(Collectors.toList());
        }
        return PLACEHOLDER_PATTERN.matcher(query).results().map(MatchResult::group).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    private static String parseQuery(Map<String, Object> config) {
        String query = (String)config.get("query");
        return JDBCResource.parseQuery(query);
    }

    private static String parseQuery(String query) {
        return PLACEHOLDER_PATTERN.matcher(query).replaceAll("?");
    }

    @Override
    public int numOfQueryParams() {
        int countForQuestionMarks = JDBCResource.countForQuestionMarks(this.query);
        int countForMapParameters = JDBCResource.countForMapParameters(this.query);
        if (countForQuestionMarks > 0 && countForMapParameters > 0) {
            throw new IllegalArgumentException("The query is mixing parameters with `$` and `?` please use just one notation");
        }
        return countForQuestionMarks > 0 ? countForQuestionMarks : countForMapParameters;
    }

    private static int countForQuestionMarks(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return 0;
        }
        return (int)Stream.of(query.split("[ (),]")).filter(Objects::nonNull).map(String::trim).filter(s -> "?".equals(s)).count();
    }

    private static int countForMapParameters(String query) {
        if (StringUtils.isBlank((CharSequence)query)) {
            return 0;
        }
        return (int)PLACEHOLDER_PATTERN.matcher(query).results().count();
    }

    @Override
    protected Map<String, Object> getProcedureParameters(Object queryParams, Map<String, Object> config) {
        List list;
        long countForQuestionMarks = JDBCResource.countForQuestionMarks(this.query);
        if (countForQuestionMarks > 0L) {
            list = (List)queryParams;
        } else {
            Map queryMap = (Map)queryParams;
            list = this.params.stream().map(param -> queryMap.get(param.substring(1))).collect(Collectors.toList());
        }
        return Map.of("url", this.url, "query", this.queryParsed, "params", list, "labels", this.labels, "config", config);
    }

    @Override
    protected String getProcedureCall(Map<String, Object> config) {
        return "CALL apoc.load.jdbc($url, $query, $params, $config) YIELD row RETURN apoc.create.vNode($labels, row) AS node";
    }
}

