/*
 * Decompiled with CFR 0.152.
 */
package apoc.bolt;

import apoc.bolt.BoltConfig;
import apoc.bolt.ClosedAwareDelegatingIterator;
import apoc.result.RowResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualRelationship;
import apoc.util.MapUtil;
import apoc.util.MissingDependencyException;
import apoc.util.UriResolver;
import apoc.util.Util;
import apoc.util.collection.Iterators;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.GraphDatabase;
import org.neo4j.driver.Record;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalEntity;
import org.neo4j.driver.internal.InternalPath;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;

public class BoltConnection {
    private final BoltConfig config;
    private final UriResolver resolver;

    public BoltConnection(BoltConfig config, UriResolver resolver) {
        this.config = config;
        this.resolver = resolver;
    }

    public static BoltConnection from(Map<String, Object> config, String url) throws URISyntaxException {
        try {
            UriResolver resolver = new UriResolver(url, "bolt");
            resolver.initialize();
            return new BoltConnection(new BoltConfig(config), resolver);
        }
        catch (NoClassDefFoundError e) {
            throw new MissingDependencyException("Cannot find the needed jar into the plugins folder in order to use . \nPlease see the documentation: https://neo4j.com/labs/apoc/4.4/database-integration/bolt-neo4j/#_install_dependencies");
        }
    }

    public Stream<RowResult> loadFromSession(String statement, Map<String, Object> params) {
        return this.withDriverAndSession(session -> {
            if (this.config.isAddStatistics()) {
                org.neo4j.driver.Result statementResult = session.run(statement, params);
                SummaryCounters counters = statementResult.consume().counters();
                return Stream.of(new RowResult(this.toMap(counters)));
            }
            return this.getRowResultStream(this.config.isVirtual(), (Session)session, params, statement);
        });
    }

    public Stream<RowResult> loadFromLocal(String localStatement, String remoteStatement, GraphDatabaseService db) {
        return this.withDriverAndSession(session -> {
            try (org.neo4j.graphdb.Transaction tx = db.beginTx();){
                Result localResult = tx.execute(localStatement, this.config.getLocalParams());
                String withColumns = "WITH " + localResult.columns().stream().map(c -> "$" + c + " AS " + c).collect(Collectors.joining(", ")) + "\n";
                HashMap nodesCache = new HashMap();
                ArrayList<RowResult> response = new ArrayList<RowResult>();
                while (localResult.hasNext()) {
                    org.neo4j.driver.Result statementResult;
                    Map row = localResult.next();
                    if (this.config.isStreamStatements()) {
                        String statement = (String)row.get("statement");
                        if (StringUtils.isBlank((CharSequence)statement)) continue;
                        Map params = Collections.singletonMap("params", row.getOrDefault("params", Collections.emptyMap()));
                        statementResult = session.run(statement, params);
                    } else {
                        statementResult = session.run(withColumns + remoteStatement, row);
                    }
                    if (this.config.isStreamStatements()) {
                        response.add(new RowResult(this.toMap(statementResult.consume().counters())));
                        continue;
                    }
                    response.addAll(statementResult.stream().map(record -> this.buildRowResult((Record)record, nodesCache, this.config.isVirtual())).collect(Collectors.toList()));
                }
                Stream stream = response.stream();
                return stream;
            }
        });
    }

    private <T> Stream<T> withDriverAndSession(Function<Session, Stream<T>> funSession) {
        return this.withDriver(driver -> this.withSession((Driver)driver, funSession));
    }

    private <T> Stream<T> withDriver(Function<Driver, Stream<T>> function) {
        Driver driver = GraphDatabase.driver((URI)this.resolver.getConfiguredUri(), (AuthToken)this.resolver.getToken(), (Config)this.config.getDriverConfig());
        return (Stream)function.apply(driver).onClose(() -> ((Driver)driver).close());
    }

    private <T> Stream<T> withSession(Driver driver, Function<Session, Stream<T>> function) {
        Session session = driver.session(this.config.getSessionConfig());
        return (Stream)function.apply(session).onClose(() -> ((Session)session).close());
    }

    private <T> Stream<T> withTransaction(Session session, Function<Transaction, Stream<T>> function) {
        Transaction transaction = session.beginTransaction();
        return (Stream)((Stream)function.apply(transaction).onClose(() -> ((Transaction)transaction).commit())).onClose(() -> ((Transaction)transaction).close());
    }

    private RowResult buildRowResult(Record record, Map<Long, Object> nodesCache, boolean virtual) {
        return new RowResult(record.asMap(value -> {
            Object entity = value.asObject();
            if (entity instanceof Node) {
                return this.toNode(entity, virtual, nodesCache);
            }
            if (entity instanceof Relationship) {
                return this.toRelationship(entity, virtual, nodesCache);
            }
            if (entity instanceof Path) {
                return this.toPath(entity, virtual, nodesCache);
            }
            return entity;
        }));
    }

    private Stream<RowResult> getRowResultStream(boolean virtual, Session session, Map<String, Object> params, String statement) {
        HashMap nodesCache = new HashMap();
        return this.withTransaction(session, tx -> {
            ClosedAwareDelegatingIterator iterator = new ClosedAwareDelegatingIterator(tx.run(statement, params));
            return Iterators.stream(iterator).map(record -> this.buildRowResult((Record)record, nodesCache, virtual));
        });
    }

    private Object toNode(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Node node = internalValue.asNode();
        if (virtual) {
            ArrayList labels = new ArrayList();
            node.labels().forEach(l -> labels.add(Label.label((String)l)));
            VirtualNode virtualNode = new VirtualNode(node.id(), labels.toArray(new Label[0]), node.asMap());
            nodesCache.put(node.id(), virtualNode);
            return virtualNode;
        }
        return Util.map((Object[])new Object[]{"entityType", internalValue.type().name(), "labels", node.labels(), "id", node.id(), "properties", node.asMap()});
    }

    private Object toRelationship(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        Value internalValue = ((InternalEntity)value).asValue();
        Relationship relationship = internalValue.asRelationship();
        if (virtual) {
            VirtualNode start = (VirtualNode)nodesCache.getOrDefault(relationship.startNodeId(), new VirtualNode(relationship.startNodeId()));
            VirtualNode end = (VirtualNode)nodesCache.getOrDefault(relationship.endNodeId(), new VirtualNode(relationship.endNodeId()));
            VirtualRelationship virtualRelationship = new VirtualRelationship(relationship.id(), (org.neo4j.graphdb.Node)start, (org.neo4j.graphdb.Node)end, RelationshipType.withName((String)relationship.type()), relationship.asMap());
            return virtualRelationship;
        }
        return Util.map((Object[])new Object[]{"entityType", internalValue.type().name(), "type", relationship.type(), "id", relationship.id(), "start", relationship.startNodeId(), "end", relationship.endNodeId(), "properties", relationship.asMap()});
    }

    private Object toPath(Object value, boolean virtual, Map<Long, Object> nodesCache) {
        LinkedList entityList = new LinkedList();
        Value internalValue = ((InternalPath)value).asValue();
        internalValue.asPath().forEach(p -> {
            entityList.add(this.toNode(p.start(), virtual, nodesCache));
            entityList.add(this.toRelationship(p.relationship(), virtual, nodesCache));
            entityList.add(this.toNode(p.end(), virtual, nodesCache));
        });
        return entityList;
    }

    private Map<String, Object> toMap(SummaryCounters resultSummary) {
        return MapUtil.map((Object[])new Object[]{"nodesCreated", resultSummary.nodesCreated(), "nodesDeleted", resultSummary.nodesDeleted(), "labelsAdded", resultSummary.labelsAdded(), "labelsRemoved", resultSummary.labelsRemoved(), "relationshipsCreated", resultSummary.relationshipsCreated(), "relationshipsDeleted", resultSummary.relationshipsDeleted(), "propertiesSet", resultSummary.propertiesSet(), "constraintsAdded", resultSummary.constraintsAdded(), "constraintsRemoved", resultSummary.constraintsRemoved(), "indexesAdded", resultSummary.indexesAdded(), "indexesRemoved", resultSummary.indexesRemoved()});
    }
}

