/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.export;

import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.security.AuthorizationViolationException;

public class CypherResultSubGraph
implements SubGraph {
    private final SortedMap<String, Node> nodes = new TreeMap<String, Node>();
    private final SortedMap<String, Relationship> relationships = new TreeMap<String, Relationship>();
    private final Collection<Label> labels = new HashSet<Label>();
    private final Collection<RelationshipType> types = new HashSet<RelationshipType>();
    private final Collection<IndexDefinition> indexes = new HashSet<IndexDefinition>();
    private final Collection<ConstraintDefinition> constraints = new HashSet<ConstraintDefinition>();

    public void add(Node node) {
        String id = node.getElementId();
        if (!this.nodes.containsKey(id)) {
            this.addNode(id, node);
        }
    }

    void addNode(String id, Node data) {
        this.nodes.put(id, data);
        this.labels.addAll(Iterables.asList(data.getLabels()));
    }

    public void add(Relationship rel, boolean addNodes) {
        String id = rel.getElementId();
        if (!this.relationships.containsKey(id)) {
            this.addRel(id, rel);
            if (addNodes) {
                this.add(rel.getStartNode());
                this.add(rel.getEndNode());
            }
        }
    }

    public static SubGraph from(Transaction tx, Result result, boolean addBetween) {
        return CypherResultSubGraph.from(tx, result, addBetween, true);
    }

    public static SubGraph from(Transaction tx, Result result, boolean addBetween, boolean addRelNodes) {
        CypherResultSubGraph graph = new CypherResultSubGraph();
        List columns = result.columns();
        try {
            result.forEachRemaining(row -> {
                for (String column : columns) {
                    Object value = row.get(column);
                    graph.addToGraph(value, addRelNodes);
                }
            });
        }
        catch (AuthorizationViolationException e) {
            throw new RuntimeException(Util.INVALID_QUERY_MODE_ERROR);
        }
        block2: for (IndexDefinition def : tx.schema().getIndexes()) {
            if (def.getIndexType() == IndexType.LOOKUP) continue;
            if (def.isNodeIndex()) {
                for (Label label : def.getLabels()) {
                    if (!graph.getLabels().contains(label)) continue;
                    graph.addIndex(def);
                    continue block2;
                }
                continue;
            }
            for (RelationshipType type : def.getRelationshipTypes()) {
                if (!graph.getTypes().contains(type)) continue;
                graph.addIndex(def);
                continue block2;
            }
        }
        for (IndexDefinition def : tx.schema().getConstraints()) {
            if (Util.isNodeCategory(def.getConstraintType()) && graph.getLabels().contains(def.getLabel())) {
                graph.addConstraint((ConstraintDefinition)def);
                continue;
            }
            if (!Util.isRelationshipCategory(def.getConstraintType()) || !graph.getTypes().contains(def.getRelationshipType())) continue;
            graph.addConstraint((ConstraintDefinition)def);
        }
        if (addBetween) {
            graph.addRelationshipsBetweenNodes();
        }
        return graph;
    }

    private void addIndex(IndexDefinition def) {
        this.indexes.add(def);
    }

    private void addConstraint(ConstraintDefinition def) {
        this.constraints.add(def);
    }

    private void addRelationshipsBetweenNodes() {
        HashSet<Node> newNodes = new HashSet<Node>();
        for (Node node : this.nodes.values()) {
            for (Relationship relationship : node.getRelationships()) {
                Node other;
                if (!this.relationships.containsKey(relationship.getElementId()) || this.nodes.containsKey((other = relationship.getOtherNode(node)).getElementId()) || newNodes.contains(other)) continue;
                newNodes.add(other);
            }
        }
        for (Node node : newNodes) {
            this.add(node);
        }
    }

    private void addToGraph(Object value, boolean addRelNodes) {
        if (value instanceof Node) {
            this.add((Node)value);
        }
        if (value instanceof Relationship) {
            this.add((Relationship)value, addRelNodes);
        }
        if (value instanceof Iterable) {
            for (Object inner : (Iterable)value) {
                this.addToGraph(inner, addRelNodes);
            }
        }
    }

    @Override
    public Iterable<Node> getNodes() {
        return this.nodes.values();
    }

    @Override
    public Iterable<Relationship> getRelationships() {
        return this.relationships.values();
    }

    public Collection<Label> getLabels() {
        return this.labels;
    }

    public Collection<RelationshipType> getTypes() {
        return this.types;
    }

    void addRel(String id, Relationship rel) {
        this.relationships.put(id, rel);
        this.types.add(rel.getType());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes() {
        return this.indexes;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints() {
        return this.constraints;
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(Label label) {
        return this.constraints.stream().filter(c -> Util.isNodeCategory(c.getConstraintType())).filter(c -> c.getLabel().equals(label)).collect(Collectors.toSet());
    }

    @Override
    public Iterable<ConstraintDefinition> getConstraints(RelationshipType type) {
        return this.constraints.stream().filter(c -> Util.isRelationshipCategory(c.getConstraintType())).filter(c -> c.getRelationshipType().equals(type)).collect(Collectors.toSet());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(Label label) {
        return this.indexes.stream().filter(IndexDefinition::isNodeIndex).filter(idx -> StreamSupport.stream(idx.getLabels().spliterator(), false).anyMatch(lb -> lb.equals(label))).collect(Collectors.toSet());
    }

    @Override
    public Iterable<IndexDefinition> getIndexes(RelationshipType type) {
        return this.indexes.stream().filter(IndexDefinition::isRelationshipIndex).filter(idx -> StreamSupport.stream(idx.getRelationshipTypes().spliterator(), false).anyMatch(relType -> relType.name().equals(type.name()))).collect(Collectors.toSet());
    }

    @Override
    public Iterable<RelationshipType> getAllRelationshipTypesInUse() {
        return Collections.unmodifiableCollection(this.types);
    }

    @Override
    public Iterable<Label> getAllLabelsInUse() {
        return Collections.unmodifiableCollection(this.labels);
    }

    @Override
    public long countsForRelationship(Label start, RelationshipType type, Label end) {
        return this.relationships.values().stream().filter(r -> {
            boolean matchType = r.getType().equals(type);
            boolean matchStart = start == null || r.getStartNode().hasLabel(start);
            boolean matchEnd = end == null || r.getEndNode().hasLabel(end);
            return matchType && matchStart && matchEnd;
        }).count();
    }

    @Override
    public long countsForNode(Label label) {
        return this.nodes.values().stream().filter(n -> n.hasLabel(label)).count();
    }

    @Override
    public Iterator<Node> findNodes(Label label) {
        return this.nodes.values().stream().filter(n -> n.hasLabel(label)).iterator();
    }
}

