/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.hdfs;

import apoc.util.StreamConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSUtils {
    private HDFSUtils() {
    }

    public static StreamConnection readFile(final String fileName) throws IOException {
        final FileSystem hdfs = HDFSUtils.getFileSystem(fileName);
        final Path file = HDFSUtils.getPath(fileName);
        final FileStatus fileStatus = hdfs.getFileStatus(file);
        return new StreamConnection(){

            @Override
            public InputStream getInputStream() throws IOException {
                return hdfs.open(file);
            }

            @Override
            public String getEncoding() {
                return "";
            }

            @Override
            public long getLength() {
                return fileStatus.getLen();
            }

            @Override
            public String getName() {
                return fileName;
            }
        };
    }

    public static StreamConnection readFile(URL url) throws IOException {
        return HDFSUtils.readFile(url.toString());
    }

    public static OutputStream writeFile(String fileName) throws IOException {
        FileSystem hdfs = HDFSUtils.getFileSystem(fileName);
        Path file = HDFSUtils.getPath(fileName);
        return hdfs.create(file);
    }

    public static Path getPath(String fileName) {
        return new Path(URI.create(fileName));
    }

    public static FileSystem getFileSystem(String fileName) throws IOException {
        Configuration configuration = new Configuration();
        return FileSystem.get((URI)URI.create(fileName), (Configuration)configuration);
    }
}

