/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import apoc.util.QueueUtil;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import org.neo4j.procedure.TerminationGuard;

public class QueueBasedSpliterator<T>
implements Spliterator<T> {
    private final BlockingQueue<T> queue;
    private T tombstone;
    private TerminationGuard terminationGuard;
    private volatile boolean foundTombstone = false;
    private final int timeoutSeconds;

    public QueueBasedSpliterator(BlockingQueue<T> queue, T tombstone, TerminationGuard terminationGuard, int timeoutSeconds) {
        this.queue = queue;
        this.tombstone = tombstone;
        this.terminationGuard = terminationGuard;
        this.timeoutSeconds = timeoutSeconds;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.foundTombstone) {
            return false;
        }
        this.terminationGuard.check();
        T element = QueueUtil.take(this.queue, this.timeoutSeconds, () -> this.terminationGuard.check());
        if (element.equals(this.tombstone)) {
            this.foundTombstone = true;
            return false;
        }
        action.accept(element);
        return true;
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return 256;
    }
}

