/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.result.VirtualNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;

public class VirtualRelationship
implements Relationship {
    private static final String ERROR_NODE_NULL = "The inserted %s Node is null";
    public static final String ERROR_START_NODE_NULL = String.format("The inserted %s Node is null", "Start");
    public static final String ERROR_END_NODE_NULL = String.format("The inserted %s Node is null", "End");
    private static AtomicLong MIN_ID = new AtomicLong(-1L);
    private final Node startNode;
    private final Node endNode;
    private final RelationshipType type;
    private final long id;
    private final Map<String, Object> props = new HashMap<String, Object>();

    public VirtualRelationship(Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        this(startNode, endNode, type);
        this.props.putAll(props);
    }

    public VirtualRelationship(Node startNode, Node endNode, RelationshipType type) {
        VirtualRelationship.validateNodes(startNode, endNode);
        this.id = MIN_ID.getAndDecrement();
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
    }

    public VirtualRelationship(long id, Node startNode, Node endNode, RelationshipType type, Map<String, Object> props) {
        VirtualRelationship.validateNodes(startNode, endNode);
        this.id = id;
        this.startNode = startNode;
        this.endNode = endNode;
        this.type = type;
        this.props.putAll(props);
    }

    public static Relationship from(VirtualNode start, VirtualNode end, Relationship rel) {
        return new VirtualRelationship(start, end, rel.getType()).withProperties(rel.getAllProperties());
    }

    public static void validateNodes(Node startNode, Node endNode) {
        Objects.requireNonNull(startNode, ERROR_START_NODE_NULL);
        Objects.requireNonNull(endNode, ERROR_END_NODE_NULL);
    }

    public long getId() {
        return this.id;
    }

    public String getElementId() {
        return String.valueOf(this.id);
    }

    public void delete() {
        if (this.getStartNode() instanceof VirtualNode) {
            ((VirtualNode)this.getStartNode()).delete(this);
        }
        if (this.getEndNode() instanceof VirtualNode) {
            ((VirtualNode)this.getEndNode()).delete(this);
        }
    }

    public Node getStartNode() {
        return this.startNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public Node getOtherNode(Node node) {
        return node.equals(this.startNode) ? this.endNode : (node.equals(this.endNode) ? this.startNode : null);
    }

    public Node[] getNodes() {
        return new Node[]{this.startNode, this.endNode};
    }

    public RelationshipType getType() {
        return this.type;
    }

    public boolean isType(RelationshipType relationshipType) {
        return relationshipType.name().equals(this.type.name());
    }

    public boolean hasProperty(String s) {
        return this.props.containsKey(s);
    }

    public Object getProperty(String s) {
        return this.props.get(s);
    }

    public Object getProperty(String s, Object o) {
        Object res = this.props.get(s);
        return res == null ? o : res;
    }

    public void setProperty(String s, Object o) {
        this.props.put(s, o);
    }

    public Object removeProperty(String s) {
        return this.props.remove(s);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }

    public Map<String, Object> getProperties(String ... strings) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(this.props);
        res.keySet().retainAll(Arrays.asList(strings));
        return res;
    }

    public Map<String, Object> getAllProperties() {
        return this.props;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Relationship && Objects.equals(this.getElementId(), ((Relationship)o).getElementId());
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }

    public Relationship withProperties(Map<String, Object> props) {
        this.props.putAll(props);
        return this;
    }

    public String toString() {
        return "VirtualRelationship{startNode=" + this.startNode.getLabels() + ", endNode=" + this.endNode.getLabels() + ", type=" + this.type + "}";
    }
}

