/*
 * Decompiled with CFR 0.152.
 */
package apoc.meta.tablesforlabels;

import apoc.meta.ConstraintTracker;
import apoc.meta.tablesforlabels.PropertyTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Entity;

public class PropertyContainerProfile {
    public long observations = 0L;
    public boolean isNode = false;
    Map<String, PropertyTracker> profile = new HashMap<String, PropertyTracker>(3);

    public Set<String> propertyNames() {
        return this.profile.keySet();
    }

    public PropertyTracker trackerFor(String propName) {
        return this.profile.get(propName);
    }

    public void observe(Entity n, boolean isNode) {
        ++this.observations;
        for (String propName : n.getPropertyKeys()) {
            PropertyTracker tracker;
            if (this.profile.containsKey(propName)) {
                tracker = this.profile.get(propName);
            } else {
                tracker = new PropertyTracker();
                this.profile.put(propName, tracker);
            }
            tracker.addObservation(n.getProperty(propName));
            tracker.mandatory = false;
            this.isNode = isNode;
        }
    }

    public PropertyContainerProfile finished() {
        for (String propName : this.propertyNames()) {
            PropertyTracker tracker;
            if (this.isNode) {
                for (Map.Entry<String, List<String>> entry : ConstraintTracker.nodeConstraints.entrySet()) {
                    for (String pk : entry.getValue()) {
                        if (!this.profile.containsKey(pk)) continue;
                        tracker = this.profile.get(pk);
                        tracker.mandatory = true;
                    }
                }
                continue;
            }
            for (Map.Entry<String, List<String>> entry : ConstraintTracker.relConstraints.entrySet()) {
                for (String pk : entry.getValue()) {
                    if (!this.profile.containsKey(pk)) continue;
                    tracker = this.profile.get(pk);
                    tracker.mandatory = true;
                }
            }
        }
        return this;
    }
}

