/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher.formatter;

import apoc.export.util.FormatUtils;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import java.lang.reflect.Array;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class CypherFormatterUtils {
    public static final String UNIQUE_ID_NAME = "UNIQUE_IMPORT_NAME";
    public static final String UNIQUE_ID_LABEL = "UNIQUE IMPORT LABEL";
    public static final String UNIQUE_ID_PROP = "UNIQUE IMPORT ID";
    public static final String Q_UNIQUE_ID_LABEL = Util.quote("UNIQUE IMPORT LABEL");
    public static final String UNIQUE_ID_REL = "UNIQUE IMPORT ID REL";
    public static final String Q_UNIQUE_ID_REL = Util.quote("UNIQUE IMPORT ID REL");
    public static final String FUNCTION_TEMPLATE = "%s('%s')";

    public static String formatNodeLookup(String id, Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(100);
        result.append("(");
        result.append(id);
        result.append(CypherFormatterUtils.getNodeIdLabels(node, uniqueConstraints, indexNames));
        Map<String, Object> nodeIdProperties = CypherFormatterUtils.getNodeIdProperties(node, uniqueConstraints);
        if (nodeIdProperties.size() > 0) {
            result.append("{");
            StringBuilder props = new StringBuilder(100);
            for (String prop : nodeIdProperties.keySet()) {
                props.append(", ");
                props.append(Util.quote(prop));
                props.append(":");
                props.append(CypherFormatterUtils.toString(nodeIdProperties.get(prop)));
            }
            result.append(props.substring(2));
            result.append("}");
        }
        result.append(")");
        return result.toString();
    }

    public static Map<String, Object> getNodeIdProperties(Node node, Map<String, Set<String>> uniqueConstraints) {
        LinkedHashMap<String, Object> nodeIdProperties = new LinkedHashMap<String, Object>();
        List<String> list = FormatUtils.getLabelsSorted(node);
        for (String labelName : list) {
            if (!CypherFormatterUtils.isUniqueLabelFound(node, uniqueConstraints, labelName)) continue;
            uniqueConstraints.get(labelName).forEach(prop -> nodeIdProperties.put((String)prop, node.getProperty(prop)));
        }
        if (nodeIdProperties.isEmpty()) {
            nodeIdProperties.put(UNIQUE_ID_PROP, node.getId());
        }
        return nodeIdProperties;
    }

    public static String formatAllLabels(Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(100);
        boolean uniqueLabelFound = false;
        List<String> list = FormatUtils.getLabelsSorted(node);
        for (String labelName : list) {
            if (!uniqueLabelFound) {
                uniqueLabelFound = CypherFormatterUtils.isUniqueLabelFound(node, uniqueConstraints, labelName);
            }
            if (indexNames != null && indexNames.contains(labelName)) {
                result.insert(0, CypherFormatterUtils.label(labelName));
                continue;
            }
            result.append(CypherFormatterUtils.label(labelName));
        }
        if (!uniqueLabelFound) {
            result.append(CypherFormatterUtils.label(UNIQUE_ID_LABEL));
        }
        return result.toString();
    }

    public static String formatNotUniqueLabels(String id, Node node, Map<String, Set<String>> uniqueConstraints) {
        StringBuilder result = new StringBuilder(100);
        List<String> list = FormatUtils.getLabelsSorted(node);
        for (String labelName : list) {
            if (CypherFormatterUtils.isUniqueLabelFound(node, uniqueConstraints, labelName)) continue;
            result.append(", ");
            result.append(id);
            result.append(CypherFormatterUtils.label(labelName));
        }
        return CypherFormatterUtils.formatToString(result);
    }

    private static String getNodeIdLabels(Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexNames) {
        StringBuilder result = new StringBuilder(100);
        List<String> list = FormatUtils.getLabelsSorted(node).stream().filter(labelName -> CypherFormatterUtils.isUniqueLabelFound(node, uniqueConstraints, labelName)).collect(Collectors.toList());
        if (list.isEmpty()) {
            result.append(CypherFormatterUtils.label(UNIQUE_ID_LABEL));
        } else {
            list.forEach(labelName -> {
                if (indexNames != null && indexNames.contains(labelName)) {
                    result.insert(0, CypherFormatterUtils.label(labelName));
                } else {
                    result.append(CypherFormatterUtils.label(labelName));
                }
            });
        }
        return result.toString();
    }

    public static boolean isUniqueLabelFound(Node node, Map<String, Set<String>> uniqueConstraints, String labelName) {
        if (uniqueConstraints.containsKey(labelName)) {
            Set<String> nodeUniqueConstraint = uniqueConstraints.get(labelName);
            return nodeUniqueConstraint.stream().allMatch(arg_0 -> ((Node)node).hasProperty(arg_0));
        }
        return false;
    }

    public static String formatNodeProperties(String id, Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexNames, boolean jsonStyle) {
        StringBuilder result = CypherFormatterUtils.formatProperties(id, node.getAllProperties(), jsonStyle);
        if (CypherFormatterUtils.getNodeIdLabels(node, uniqueConstraints, indexNames).endsWith(CypherFormatterUtils.label(UNIQUE_ID_LABEL))) {
            result.append(", ");
            result.append(CypherFormatterUtils.formatPropertyName(id, UNIQUE_ID_PROP, node.getId(), jsonStyle));
        }
        return CypherFormatterUtils.formatToString(result);
    }

    public static String formatRelationshipProperties(String id, Relationship relationship, boolean jsonStyle) {
        StringBuilder result = CypherFormatterUtils.formatProperties(id, relationship.getAllProperties(), jsonStyle);
        return CypherFormatterUtils.formatToString(result);
    }

    public static String formatNotUniqueProperties(String id, Node node, Map<String, Set<String>> uniqueConstraints, Set<String> indexedProperties, boolean jsonStyle) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        List<String> keys = Iterables.asList(node.getPropertyKeys());
        Collections.sort(keys);
        Map<String, Object> nodeIdProperties = CypherFormatterUtils.getNodeIdProperties(node, uniqueConstraints);
        for (String prop : keys) {
            if (nodeIdProperties.containsKey(prop) || !indexedProperties.contains(prop)) continue;
            properties.put(prop, node.getProperty(prop));
        }
        for (String prop : keys) {
            if (nodeIdProperties.containsKey(prop) || indexedProperties.contains(prop)) continue;
            properties.put(prop, node.getProperty(prop));
        }
        StringBuilder result = new StringBuilder(100);
        for (String key : properties.keySet()) {
            result.append(", ");
            result.append(CypherFormatterUtils.formatPropertyName(id, key, properties.get(key), jsonStyle));
        }
        return CypherFormatterUtils.formatToString(result);
    }

    public static String formatToString(StringBuilder result) {
        return result.length() > 0 ? result.substring(2) : "";
    }

    public static StringBuilder formatProperties(Map<String, Object> properties) {
        return CypherFormatterUtils.formatProperties("", properties, true);
    }

    public static StringBuilder formatProperties(String id, Map<String, Object> properties, boolean jsonStyle) {
        StringBuilder result = new StringBuilder(100);
        if (properties != null && !properties.isEmpty()) {
            List<String> keys = Iterables.asList(properties.keySet());
            Collections.sort(keys);
            for (String prop : keys) {
                result.append(", ");
                result.append(CypherFormatterUtils.formatPropertyName(id, prop, properties.get(prop), jsonStyle));
            }
        }
        return result;
    }

    public static String formatPropertyName(String id, String prop, Object value, boolean jsonStyle) {
        return (String)(id != null && !"".equals(id) ? id + "." : "") + Util.quote(prop) + (jsonStyle ? ":" : "=") + CypherFormatterUtils.toString(value);
    }

    public static String label(String id) {
        return ":" + Util.quote(id);
    }

    public static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return FormatUtils.formatString(value);
        }
        if (value instanceof Number) {
            return FormatUtils.formatNumber((Number)value);
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Iterator) {
            return CypherFormatterUtils.toString((Iterator)value);
        }
        if (value instanceof Iterable) {
            return CypherFormatterUtils.toString(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return CypherFormatterUtils.arrayToString(value);
        }
        if (value instanceof Temporal) {
            Value val = Values.of((Object)value);
            return CypherFormatterUtils.toStringFunction(val);
        }
        if (value instanceof DurationValue) {
            return CypherFormatterUtils.toStringFunction((Value)((DurationValue)value));
        }
        return value.toString();
    }

    private static String toStringFunction(Value value) {
        return String.format(FUNCTION_TEMPLATE, value.getTypeName().toLowerCase(), value.toString());
    }

    public static String toString(Iterator<?> iterator) {
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            Object value = iterator.next();
            result.append(CypherFormatterUtils.toString(value));
        }
        return "[" + result + "]";
    }

    public static String arrayToString(Object value) {
        int length = Array.getLength(value);
        StringBuilder result = new StringBuilder(10 * length);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(CypherFormatterUtils.toString(Array.get(value, i)));
        }
        return "[" + result.toString() + "]";
    }

    public static String cypherNode(Label label) {
        return String.format("(%s)", label == null ? "" : ":" + Util.quote(label.name()));
    }

    public static String simpleKeyValue(String key, Object value) {
        return String.format("{%s:%s}", key, value);
    }
}

