/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.cypher;

import apoc.export.cypher.ExportFileManager;
import apoc.export.util.ExportConfig;
import apoc.util.FileUtils;
import apoc.util.Util;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileManagerFactory {
    private static final String DOT = ".";

    public static ExportFileManager createFileManager(String fileName, boolean separatedFiles) {
        return FileManagerFactory.createFileManager(fileName, separatedFiles, ExportConfig.EMPTY);
    }

    public static ExportFileManager createFileManager(String fileName, boolean separatedFiles, ExportConfig config) {
        if (fileName == null || "".equals(fileName)) {
            return new StringExportCypherFileManager(separatedFiles, config);
        }
        fileName = fileName.trim();
        String fileType = FilenameUtils.getExtension((String)fileName);
        return new PhysicalExportFileManager(fileType, fileName, separatedFiles, config);
    }

    private static class StringExportCypherFileManager
    implements ExportFileManager {
        private final boolean separatedFiles;
        private final ExportConfig config;
        private final ConcurrentMap<String, StringWriter> writers = new ConcurrentHashMap<String, StringWriter>();

        public StringExportCypherFileManager(boolean separatedFiles, ExportConfig config) {
            this.separatedFiles = separatedFiles;
            this.config = config;
        }

        @Override
        public PrintWriter getPrintWriter(String type) {
            if (!this.separatedFiles) {
                switch (type) {
                    case "csv": 
                    case "json": 
                    case "graphml": {
                        break;
                    }
                    default: {
                        type = "cypher";
                    }
                }
            }
            return new PrintWriter(this.getStringWriter(type));
        }

        @Override
        public StringWriter getStringWriter(String type) {
            return this.writers.computeIfAbsent(type, key -> new StringWriter());
        }

        @Override
        public synchronized Object drain(String type) {
            StringWriter writer = (StringWriter)this.writers.get(type);
            if (writer != null) {
                return Util.getStringOrCompressedData(writer, this.config);
            }
            return null;
        }

        @Override
        public Boolean separatedFiles() {
            return this.separatedFiles;
        }
    }

    private static class PhysicalExportFileManager
    implements ExportFileManager {
        private final String fileName;
        private final String fileType;
        private final boolean separatedFiles;
        private final Map<String, PrintWriter> writerCache;
        private ExportConfig config;

        public PhysicalExportFileManager(String fileType, String fileName, boolean separatedFiles, ExportConfig config) {
            this.fileType = StringUtils.isBlank((CharSequence)fileType) ? "" : fileType;
            this.fileName = fileName;
            this.separatedFiles = separatedFiles;
            this.config = config;
            this.writerCache = new ConcurrentHashMap<String, PrintWriter>();
        }

        @Override
        public PrintWriter getPrintWriter(String type) {
            String newFileName = this.separatedFiles ? this.normalizeFileName(this.fileName, type) : this.normalizeFileName(this.fileName, null);
            return this.writerCache.computeIfAbsent(newFileName, key -> {
                OutputStream outputStream = FileUtils.getOutputStream(newFileName, this.config);
                return outputStream == null ? null : new PrintWriter(outputStream);
            });
        }

        @Override
        public StringWriter getStringWriter(String type) {
            return null;
        }

        private String normalizeFileName(String fileName, String suffix) {
            if (StringUtils.isBlank((CharSequence)suffix)) {
                return fileName;
            }
            if (StringUtils.isEmpty((CharSequence)this.fileType)) {
                return fileName + FileManagerFactory.DOT + suffix;
            }
            return fileName.replace(this.fileType, suffix + FileManagerFactory.DOT + this.fileType);
        }

        @Override
        public String drain(String type) {
            return null;
        }

        @Override
        public Boolean separatedFiles() {
            return this.separatedFiles;
        }
    }
}

