/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v520;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.Mask;

public class LogEntryDetachedCheckpointV5_20
extends AbstractVersionAwareLogEntry {
    private final TransactionId transactionId;
    private final long lastAppendIndex;
    private final LogPosition logPosition;
    private final long checkpointTime;
    private final StoreId storeId;
    private final String reason;
    private final boolean consensusIndexInCheckpoint;

    public LogEntryDetachedCheckpointV5_20(KernelVersion kernelVersion, TransactionId transactionId, long lastAppendIndex, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason) {
        super(kernelVersion, (byte)9);
        this.transactionId = transactionId;
        this.logPosition = logPosition;
        this.checkpointTime = checkpointMillis;
        this.storeId = storeId;
        this.lastAppendIndex = lastAppendIndex;
        this.reason = reason;
        this.consensusIndexInCheckpoint = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV5_20 that = (LogEntryDetachedCheckpointV5_20)o;
        return this.lastAppendIndex == that.lastAppendIndex && this.checkpointTime == that.checkpointTime && this.consensusIndexInCheckpoint == that.consensusIndexInCheckpoint && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.logPosition, that.logPosition) && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.transactionId, this.lastAppendIndex, this.logPosition, this.checkpointTime, this.storeId, this.reason, this.consensusIndexInCheckpoint);
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LogPosition getLogPosition() {
        return this.logPosition;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public String getReason() {
        return this.reason;
    }

    public long getCheckpointTime() {
        return this.checkpointTime;
    }

    public boolean consensusIndexInCheckpoint() {
        return this.consensusIndexInCheckpoint;
    }

    public long getLastAppendIndex() {
        return this.lastAppendIndex;
    }

    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpointV5_20{transactionId=" + String.valueOf(this.transactionId) + ", lastAppendIndex=" + this.lastAppendIndex + ", logPosition=" + String.valueOf(this.logPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "', consensusIndexInCheckpoint=" + this.consensusIndexInCheckpoint + "}";
    }
}

