/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v50;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.string.Mask;

public class LogEntryDetachedCheckpointV5_0
extends AbstractVersionAwareLogEntry {
    private final TransactionId transactionId;
    private final LogPosition logPosition;
    private final long checkpointTime;
    private final StoreId storeId;
    private final String reason;
    private final boolean consensusIndexInCheckpoint;

    public LogEntryDetachedCheckpointV5_0(KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason) {
        this(kernelVersion, transactionId, logPosition, checkpointMillis, storeId, reason, true);
    }

    public LogEntryDetachedCheckpointV5_0(KernelVersion kernelVersion, TransactionId transactionId, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason, boolean consensusIndexInCheckpoint) {
        super(kernelVersion, (byte)9);
        this.transactionId = transactionId;
        this.logPosition = logPosition;
        this.checkpointTime = checkpointMillis;
        this.storeId = storeId;
        this.reason = reason;
        this.consensusIndexInCheckpoint = consensusIndexInCheckpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV5_0 that = (LogEntryDetachedCheckpointV5_0)o;
        return this.checkpointTime == that.checkpointTime && Objects.equals(this.transactionId, that.transactionId) && Objects.equals(this.logPosition, that.logPosition) && Objects.equals(this.storeId, that.storeId) && this.kernelVersion() == that.kernelVersion() && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.kernelVersion(), this.transactionId, this.logPosition, this.checkpointTime, this.storeId, this.reason);
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LogPosition getLogPosition() {
        return this.logPosition;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public String getReason() {
        return this.reason;
    }

    public long getCheckpointTime() {
        return this.checkpointTime;
    }

    public boolean consensusIndexInCheckpoint() {
        return this.consensusIndexInCheckpoint;
    }

    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpointV5_0{transactionId=" + String.valueOf(this.transactionId) + ", logPosition=" + String.valueOf(this.logPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "', version=" + String.valueOf(this.kernelVersion()) + "}";
    }
}

