/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry.v42;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractVersionAwareLogEntry;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.string.Mask;

public class LogEntryDetachedCheckpointV4_2
extends AbstractVersionAwareLogEntry {
    private final LogPosition logPosition;
    private final long checkpointTime;
    private final StoreId storeId;
    private final String reason;

    public LogEntryDetachedCheckpointV4_2(KernelVersion kernelVersion, LogPosition logPosition, long checkpointMillis, StoreId storeId, String reason) {
        super(kernelVersion, (byte)8);
        this.logPosition = logPosition;
        this.checkpointTime = checkpointMillis;
        this.storeId = storeId;
        this.reason = reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryDetachedCheckpointV4_2 that = (LogEntryDetachedCheckpointV4_2)o;
        return Objects.equals(this.logPosition, that.logPosition) && this.checkpointTime == that.checkpointTime && this.kernelVersion() == that.kernelVersion() && Objects.equals(this.storeId, that.storeId) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(this.kernelVersion(), this.logPosition, this.checkpointTime, this.storeId, this.reason);
    }

    public StoreId getStoreId() {
        return this.storeId;
    }

    public LogPosition getLogPosition() {
        return this.logPosition;
    }

    public String getReason() {
        return this.reason;
    }

    public long getCheckpointTime() {
        return this.checkpointTime;
    }

    public String toString(Mask mask) {
        return "LogEntryDetachedCheckpointV4_2{version=" + String.valueOf(this.kernelVersion()) + ", logPosition=" + String.valueOf(this.logPosition) + ", checkpointTime=" + this.checkpointTime + ", storeId=" + String.valueOf(this.storeId) + ", reason='" + this.reason + "'}";
    }
}

