/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryCommitV4_2;
import org.neo4j.kernel.impl.transaction.log.entry.v42.LogEntryStartV4_2;

public final class LogEntryFactory {
    private LogEntryFactory() {
    }

    public static LogEntryStart newStartEntry(KernelVersion version, long timeWritten, long lastCommittedTxWhenTransactionStarted, int previousChecksum, byte[] additionalHeader, LogPosition startPosition) {
        if (version.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
            return new LogEntryStart(version, timeWritten, lastCommittedTxWhenTransactionStarted, additionalHeader, startPosition);
        }
        return new LogEntryStartV4_2(version, timeWritten, lastCommittedTxWhenTransactionStarted, previousChecksum, additionalHeader, startPosition);
    }

    public static LogEntryCommit newCommitEntry(KernelVersion version, long txId, long timeWritten, int checksum) {
        if (version.isAtLeast(KernelVersion.VERSION_ENVELOPED_TRANSACTION_LOGS_INTRODUCED)) {
            return new LogEntryCommit(version, txId, timeWritten);
        }
        return new LogEntryCommitV4_2(version, txId, timeWritten, checksum);
    }
}

