/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.util.Objects;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.entry.AbstractLogEntry;
import org.neo4j.storageengine.api.Mask;

public class LogEntryCommit
extends AbstractLogEntry {
    private final long txId;
    private final long timeWritten;
    private final int checksum;

    public LogEntryCommit(long txId, long timeWritten, int checksum) {
        this(KernelVersion.LATEST, txId, timeWritten, checksum);
    }

    public LogEntryCommit(KernelVersion version, long txId, long timeWritten, int checksum) {
        super(version, (byte)5);
        this.txId = txId;
        this.timeWritten = timeWritten;
        this.checksum = checksum;
    }

    public long getTxId() {
        return this.txId;
    }

    public long getTimeWritten() {
        return this.timeWritten;
    }

    public int getChecksum() {
        return this.checksum;
    }

    @Override
    public String toString(Mask mask) {
        return "Commit[txId=" + this.getTxId() + ", " + this.timestamp(this.getTimeWritten()) + ", checksum=" + this.checksum + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LogEntryCommit that = (LogEntryCommit)o;
        return this.txId == that.txId && this.timeWritten == that.timeWritten && this.checksum == that.checksum;
    }

    public int hashCode() {
        return Objects.hash(this.txId, this.timeWritten, this.checksum);
    }
}

