/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.utils.TemporalUtil;

public abstract class TemporalValueWriterAdapter<E extends Exception>
extends ValueWriter.Adapter<E> {
    @Override
    public final void writeDate(LocalDate localDate) throws E {
        this.writeDate(localDate.toEpochDay());
    }

    @Override
    public final void writeLocalTime(LocalTime localTime) throws E {
        this.writeLocalTime(localTime.toNanoOfDay());
    }

    @Override
    public final void writeTime(OffsetTime offsetTime) throws E {
        long nanosOfDayUTC = TemporalUtil.getNanosOfDayUTC(offsetTime);
        int offsetSeconds = offsetTime.getOffset().getTotalSeconds();
        this.writeTime(nanosOfDayUTC, offsetSeconds);
    }

    @Override
    public final void writeLocalDateTime(LocalDateTime localDateTime) throws E {
        long epochSecond = localDateTime.toEpochSecond(ZoneOffset.UTC);
        int nano = localDateTime.getNano();
        this.writeLocalDateTime(epochSecond, nano);
    }

    @Override
    public final void writeDateTime(ZonedDateTime zonedDateTime) throws E {
        long epochSecondUTC = zonedDateTime.toEpochSecond();
        int nano = zonedDateTime.getNano();
        ZoneId zone = zonedDateTime.getZone();
        if (zone instanceof ZoneOffset) {
            int offsetSeconds = ((ZoneOffset)zone).getTotalSeconds();
            this.writeDateTime(epochSecondUTC, nano, offsetSeconds);
        } else {
            String zoneId = zone.getId();
            this.writeDateTime(epochSecondUTC, nano, zoneId);
        }
    }

    protected void writeDate(long epochDay) throws E {
    }

    protected void writeLocalTime(long nanoOfDay) throws E {
    }

    protected void writeTime(long nanosOfDayUTC, int offsetSeconds) throws E {
    }

    protected void writeLocalDateTime(long epochSecond, int nano) throws E {
    }

    protected void writeDateTime(long epochSecondUTC, int nano, int offsetSeconds) throws E {
    }

    protected void writeDateTime(long epochSecondUTC, int nano, String zoneId) throws E {
    }
}

